/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.nioneo.store.DynamicBlockSize;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.ExistingThenNewRecordAllocator;
import org.neo4j.kernel.impl.nioneo.store.IdSequence;

public class ExistingThenNewRecordAllocatorTest {
    @Test
    public void shouldUseExistingRecordsThenAllocateNewOnes() throws Exception {
        IdSequence mock = (IdSequence)Mockito.mock(IdSequence.class);
        Mockito.when((Object)mock.nextId()).thenReturn((Object)3L).thenReturn((Object)4L);
        ExistingThenNewRecordAllocator allocator = new ExistingThenNewRecordAllocator((DynamicBlockSize)Mockito.mock(DynamicBlockSize.class), mock);
        Iterator<DynamicRecord> existing = Arrays.asList(new DynamicRecord(1L), new DynamicRecord(2L)).iterator();
        DynamicRecord record1 = allocator.nextUsedRecordOrNew(existing);
        DynamicRecord record2 = allocator.nextUsedRecordOrNew(existing);
        DynamicRecord record3 = allocator.nextUsedRecordOrNew(existing);
        DynamicRecord record4 = allocator.nextUsedRecordOrNew(existing);
        Assert.assertEquals((long)1L, (long)record1.getId());
        Assert.assertEquals((long)2L, (long)record2.getId());
        Assert.assertEquals((long)3L, (long)record3.getId());
        Assert.assertEquals((long)4L, (long)record4.getId());
    }
}

