/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.MappedPersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.ResourceCollection;
import org.neo4j.test.TargetDirectory;

public class MappedPersistenceWindowTest {
    private static final TargetDirectory target = TargetDirectory.forTest(MappedPersistenceWindowTest.class);
    @Rule
    public final TargetDirectory.TestDirectory directory = target.testDirectory();
    @Rule
    public final ResourceCollection resources = new ResourceCollection();

    @Test
    public void shouldCloseUnusedWindow() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        MappedPersistenceWindow window = new MappedPersistenceWindow(0L, 8, 16, (StoreChannel)channel, FileChannel.MapMode.READ_WRITE);
        boolean wasClosed = window.writeOutAndCloseIfFree(false);
        file.close();
        Assert.assertTrue((boolean)wasClosed);
    }

    @Test
    public void shouldNotCloseMarkedWindow() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        MappedPersistenceWindow window = new MappedPersistenceWindow(0L, 8, 16, (StoreChannel)channel, FileChannel.MapMode.READ_WRITE);
        window.markAsInUse();
        boolean wasClosed = window.writeOutAndCloseIfFree(false);
        file.close();
        Assert.assertFalse((boolean)wasClosed);
    }

    @Test
    public void shouldNotCloseLockedWindow() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        final MappedPersistenceWindow window = new MappedPersistenceWindow(0L, 8, 16, (StoreChannel)channel, FileChannel.MapMode.READ_WRITE);
        window.markAsInUse();
        OtherThreadExecutor<Object> executor = new OtherThreadExecutor<Object>("other thread", null);
        executor.execute(new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) {
                window.lock(OperationType.WRITE);
                return null;
            }
        });
        boolean wasClosed = window.writeOutAndCloseIfFree(false);
        file.close();
        Assert.assertFalse((boolean)wasClosed);
        executor.close();
    }

    @Test
    public void shouldCloseReleasedWindow() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        MappedPersistenceWindow window = new MappedPersistenceWindow(0L, 8, 16, (StoreChannel)channel, FileChannel.MapMode.READ_WRITE);
        window.markAsInUse();
        window.lock(OperationType.WRITE);
        window.unLock();
        boolean wasClosed = window.writeOutAndCloseIfFree(false);
        file.close();
        Assert.assertTrue((boolean)wasClosed);
    }
}

