/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PreAllocatedRecords;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class NodeStoreTest {
    @Test
    public void shouldReadFirstFromSingleRecordDynamicLongArray() throws Exception {
        Long expectedId = 12L;
        long[] ids = new long[]{expectedId, 23L, 42L};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        List<DynamicRecord> dynamicRecords = Arrays.asList(firstRecord);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, dynamicRecords.iterator(), (DynamicRecordAllocator)new PreAllocatedRecords(60));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals((Object)expectedId, (Object)firstId);
    }

    @Test
    public void shouldReadFirstAsNullFromEmptyDynamicLongArray() throws Exception {
        Object expectedId = null;
        long[] ids = new long[]{};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        List<DynamicRecord> dynamicRecords = Arrays.asList(firstRecord);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, dynamicRecords.iterator(), (DynamicRecordAllocator)new PreAllocatedRecords(60));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals(expectedId, (Object)firstId);
    }

    @Test
    public void shouldReadFirstFromTwoRecordDynamicLongArray() throws Exception {
        Long expectedId = 12L;
        long[] ids = new long[]{expectedId, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        List<DynamicRecord> dynamicRecords = Arrays.asList(firstRecord, new DynamicRecord(1L));
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, dynamicRecords.iterator(), (DynamicRecordAllocator)new PreAllocatedRecords(8));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals((Object)expectedId, (Object)firstId);
    }

    @Test
    public void shouldCombineProperFiveByteLabelField() throws Exception {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        Config config = new Config();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
        DefaultWindowPoolFactory windowPoolFactory = new DefaultWindowPoolFactory();
        StoreFactory factory = new StoreFactory(config, (IdGeneratorFactory)idGeneratorFactory, (WindowPoolFactory)windowPoolFactory, (FileSystemAbstraction)fs, StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
        File nodeStoreFileName = new File("nodestore");
        factory.createNodeStore(nodeStoreFileName);
        NodeStore nodeStore = factory.newNodeStore(nodeStoreFileName);
        long nodeId = 0L;
        long labels = 0x8000000001L;
        NodeRecord record = new NodeRecord(nodeId, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        record.setInUse(true);
        record.setLabelField(labels, Collections.emptyList());
        nodeStore.updateRecord(record);
        NodeRecord readRecord = nodeStore.getRecord(nodeId);
        Assert.assertEquals((long)labels, (long)readRecord.getLabelField());
        nodeStore.close();
        fs.shutdown();
    }

    @Test
    public void shouldKeepRecordLightWhenSettingLabelFieldWithoutDynamicRecords() throws Exception {
        NodeRecord record = new NodeRecord(0L, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        record.setLabelField(0L, Collections.emptyList());
        Assert.assertTrue((boolean)record.isLight());
    }

    @Test
    public void shouldMarkRecordHeavyWhenSettingLabelFieldWithDynamicRecords() throws Exception {
        NodeRecord record = new NodeRecord(0L, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        DynamicRecord dynamicRecord = new DynamicRecord(1L);
        record.setLabelField(0x8000000001L, Arrays.asList(dynamicRecord));
        Assert.assertFalse((boolean)record.isLight());
    }
}

