/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.kernel.impl.nioneo.store.BrickElementFactory;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceRow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@RunWith(value=SubProcessTestRunner.class)
@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.nioneo.store.PersistenceRow", method="lock", on=BreakPoint.Event.ENTRY)})
@Ignore(value="Fix pending")
public class PersistenceRowAndWindowDirtyWriteIT {
    private static DebuggedThread theTriggeringOne;
    private static DebuggedThread theEvilOne;

    @Test
    @EnabledBreakpoints(value={"waitForFirstWriterToWrite", "waitForBreakingToAcquire"})
    public void theTest() throws Exception {
        File dataFile = TargetDirectory.forTest(this.getClass()).file("dataFile");
        StoreFileChannel dataFileChannel = new StoreFileChannel(new RandomAccessFile(dataFile, "rw").getChannel());
        final PersistenceWindowPool pool = new PersistenceWindowPool(dataFile, 4, (StoreChannel)dataFileChannel, 50000L, true, false, new ConcurrentHashMap(), BrickElementFactory.DEFAULT, StringLogger.DEV_NULL);
        Thread theTriggeringOne = new Thread(new Runnable(){

            @Override
            public void run() {
                pool.release(pool.acquire(13L, OperationType.READ));
                for (int i = 0; i < 49997; ++i) {
                    pool.release(pool.acquire(1L, OperationType.READ));
                }
                PersistenceRow row = (PersistenceRow)pool.acquire(1L, OperationType.WRITE);
                row.getOffsettedBuffer(1L).put(new byte[]{1, 2, 3, 4});
                PersistenceRowAndWindowDirtyWriteIT.this.waitForBreakingToAcquire();
                pool.release((PersistenceWindow)row);
            }
        });
        final CountDownLatch theOverwrittenOneHasWrittenItsChanges = new CountDownLatch(1);
        final CountDownLatch theBreakingOneHasLockedTheRow = new CountDownLatch(1);
        Thread theEvilOne = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PersistenceRowAndWindowDirtyWriteIT.this.waitForFirstWriterToWrite();
                    PersistenceRow row = (PersistenceRow)pool.acquire(1L, OperationType.READ);
                    theBreakingOneHasLockedTheRow.countDown();
                    theOverwrittenOneHasWrittenItsChanges.await();
                    pool.release((PersistenceWindow)row);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        Thread theOverwrittenOne = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    theBreakingOneHasLockedTheRow.await();
                    LockableWindow window = (LockableWindow)pool.acquire(1L, OperationType.WRITE);
                    window.getOffsettedBuffer(1L).put(new byte[]{5, 6, 7, 8});
                    pool.release((PersistenceWindow)window);
                    theOverwrittenOneHasWrittenItsChanges.countDown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        theEvilOne.start();
        theOverwrittenOne.start();
        theTriggeringOne.start();
        theEvilOne.join();
        theTriggeringOne.join();
        theOverwrittenOne.join();
        byte[] finalResult = new byte[4];
        pool.acquire(1L, OperationType.READ).getOffsettedBuffer(1L).get(finalResult);
        Assert.assertTrue((String)Arrays.toString(finalResult), (boolean)Arrays.equals(new byte[]{5, 6, 7, 8}, finalResult));
        pool.close();
    }

    @BreakpointTrigger(value="waitForFirstWriterToWrite")
    public void waitForFirstWriterToWrite() {
    }

    @BreakpointHandler(value={"waitForFirstWriterToWrite"})
    public static void waitForFirstWriterToWriteHandler(BreakPoint self, DebugInterface di) {
        theEvilOne = di.thread().suspend(null);
        self.disable();
    }

    @BreakpointTrigger(value="waitForBreakingToAcquire")
    public void waitForBreakingToAcquire() {
    }

    @BreakpointHandler(value={"waitForBreakingToAcquire"})
    public static void waitForBreakingToAcquireHandler(BreakPoint self, DebugInterface di, @BreakpointHandler(value={"lock"}) BreakPoint onWindowLock) {
        theEvilOne.resume();
        theTriggeringOne = di.thread().suspend(null);
        onWindowLock.enable();
        self.disable();
    }

    @BreakpointHandler(value={"lock"})
    public static void lockHandler(BreakPoint self, DebugInterface di) {
        theTriggeringOne.resume();
        self.disable();
    }
}

