/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceRow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;

public class PersistenceRowTest {
    private static final Random RANDOM = new Random();
    private static final int RECORD_SIZE = 7;
    private PersistenceRow window;
    private StoreFileChannel realChannel;

    @Before
    public void before() throws Exception {
        File directory = new File("target/test-data");
        directory.mkdirs();
        String filename = new File(directory, UUID.randomUUID().toString()).getAbsolutePath();
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        this.realChannel = new StoreFileChannel(file.getChannel());
        this.window = new PersistenceRow(0L, 7, (StoreChannel)this.realChannel);
        this.window.lock(OperationType.WRITE);
    }

    @Test
    public void shouldNotLetChangesToOffsetInterfereWithFlushing() throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    PersistenceRowTest.this.window.getBuffer().setOffset(RANDOM.nextInt(PersistenceRowTest.this.window.getBuffer().getBuffer().limit()));
                }
            }
        }).start();
        try {
            for (int i = 1; i < 10000; ++i) {
                this.window.force();
            }
        }
        catch (BufferOverflowException e) {
            Assert.fail((String)"Changing the state of the buffer's flags should not affect flushing");
        }
    }

    @Test
    public void shouldNotLetFlushingInterfereWithReads() throws Exception {
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        Assert.assertThat((Object)this.window.getBuffer().getBuffer().position(), (Matcher)Is.is((Object)4));
        this.window.force();
        Assert.assertThat((Object)this.window.getBuffer().getBuffer().position(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void grabbingWriteLockShouldMarkRowAsDirty() throws Exception {
        StoreFileChannel channel = (StoreFileChannel)Mockito.spy((Object)this.realChannel);
        PersistenceRow row = new PersistenceRow(0L, 1, (StoreChannel)channel);
        row.lock(OperationType.WRITE);
        Assert.assertThat((String)"Dirty before force", (Object)row.isDirty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void forcingARowShouldMarkItAsClean() throws Exception {
        StoreFileChannel channel = (StoreFileChannel)Mockito.spy((Object)this.realChannel);
        PersistenceRow row = new PersistenceRow(0L, 1, (StoreChannel)channel);
        row.lock(OperationType.WRITE);
        row.force();
        Assert.assertThat((String)"Dirty after force", (Object)row.isDirty(), (Matcher)Is.is((Object)false));
        ((StoreFileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)Matchers.any(ByteBuffer.class), Matchers.anyLong());
        row.force();
        ((StoreFileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)Matchers.any(ByteBuffer.class), Matchers.anyLong());
        Assert.assertThat((String)"Dirty after non-flushing force", (Object)row.isDirty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void explicitlyMarkingAsCleanShouldDoSo() throws Exception {
        StoreFileChannel channel = (StoreFileChannel)Mockito.spy((Object)this.realChannel);
        PersistenceRow row = new PersistenceRow(0L, 1, (StoreChannel)channel);
        row.lock(OperationType.WRITE);
        row.setClean();
        Assert.assertThat((String)"Dirty after setting clean", (Object)row.isDirty(), (Matcher)Is.is((Object)false));
    }
}

