/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.BrickElementFactory;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class PersistenceWindowPoolRaceTestIT {
    private static final Throwable STOP_SIGNAL = new Throwable("Test stop signal");
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(PersistenceWindowPoolRaceTestIT.class);

    @Test
    public void raceOnClaimReleaseForAtMost30Seconds() throws Throwable {
        Throwable observedFailure;
        AcquireReleaseJob[] jobs;
        ExecutorService executor = Executors.newCachedThreadPool();
        File file = new File(this.testDir.directory(), "test.file.db");
        int blockSize = 512;
        int maxId = 10000;
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel fileChannel = raf.getChannel();
        this.setSize(fileChannel, blockSize * maxId);
        long mappedMem = blockSize + blockSize * (maxId / 10) + blockSize / 2;
        boolean useMemoryMappedBuffers = true;
        boolean readOnly = false;
        ConcurrentHashMap activeRowWindows = new ConcurrentHashMap();
        BrickElementFactory brickFactory = BrickElementFactory.DEFAULT;
        StringLogger log = StringLogger.DEV_NULL;
        PersistenceWindowPool pwp = new PersistenceWindowPool(file, blockSize, (StoreChannel)new StoreFileChannel(fileChannel), mappedMem, useMemoryMappedBuffers, readOnly, activeRowWindows, brickFactory, log);
        for (int i = 0; i <= 9; ++i) {
            PersistenceWindow window = pwp.acquire((long)(i * 10), OperationType.WRITE);
            pwp.release(window);
        }
        AtomicReference<Throwable> mailbox = new AtomicReference<Throwable>();
        for (AcquireReleaseJob job : jobs = new AcquireReleaseJob[]{new AcquireReleaseJob(pwp, maxId, mailbox), new AcquireReleaseJob(pwp, maxId, mailbox), new AcquireReleaseJob(pwp, maxId, mailbox), new AcquireReleaseJob(pwp, maxId, mailbox), new AcquireReleaseJob(pwp, maxId, mailbox), new AcquireReleaseJob(pwp, maxId, mailbox), new AcquireReleaseJob(pwp, maxId, mailbox), new AcquireReleaseJob(pwp, maxId, mailbox)}) {
            executor.submit(job);
        }
        long deadline = System.currentTimeMillis() + 30000L;
        do {
            Thread.sleep(100L);
        } while ((observedFailure = mailbox.get()) == null && System.currentTimeMillis() < deadline);
        executor.shutdown();
        mailbox.compareAndSet(null, STOP_SIGNAL);
        pwp.close();
        raf.close();
        if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            System.err.println("WARNING: Executor did not terminate after 10 seconds.");
        }
        if (observedFailure != null) {
            throw observedFailure;
        }
    }

    private void setSize(FileChannel fileChannel, long sizeInBytes) throws IOException {
        fileChannel.write(ByteBuffer.wrap(new byte[]{0}), sizeInBytes - 1L);
    }

    private static class AcquireReleaseJob
    implements Runnable {
        private final PersistenceWindowPool pwp;
        private final AtomicReference<Throwable> mailbox;
        private final long maxId;

        public AcquireReleaseJob(PersistenceWindowPool pwp, int maxId, AtomicReference<Throwable> mailbox) {
            this.pwp = pwp;
            this.mailbox = mailbox;
            this.maxId = maxId - 1;
        }

        @Override
        public void run() {
            Random random = new Random();
            try {
                while (this.mailbox.get() == null) {
                    long id = Math.abs(random.nextLong() % this.maxId);
                    PersistenceWindow window = this.pwp.acquire(id, OperationType.WRITE);
                    window.getOffsettedBuffer(id).put((byte)(0xFF & random.nextInt()));
                    this.pwp.release(window);
                }
            }
            catch (Throwable e) {
                this.mailbox.set(e);
            }
        }
    }
}

