/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.nioneo.store.BrickElement;
import org.neo4j.kernel.impl.nioneo.store.BrickElementFactory;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.MappedPersistenceWindowTest;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceRow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.ResourceCollection;
import org.neo4j.test.TargetDirectory;

public class PersistenceWindowPoolTest {
    private static final TargetDirectory target = TargetDirectory.forTest(MappedPersistenceWindowTest.class);
    @Rule
    public final ResourceCollection resources = new ResourceCollection();
    @Rule
    public final TargetDirectory.TestDirectory directory = target.testDirectory();
    @Rule
    public final ExpectedException expectedUnderlyingException = ExpectedException.none();

    @Test
    public void shouldBeAbleToReAcquireReleasedWindow() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        PersistenceWindowPool pool = new PersistenceWindowPool(new File("test.store"), 8, (StoreChannel)channel, 0L, false, false, new ConcurrentHashMap(), BrickElementFactory.DEFAULT, StringLogger.DEV_NULL);
        PersistenceWindow initialWindow = pool.acquire(0L, OperationType.READ);
        pool.release(initialWindow);
        PersistenceWindow window = pool.acquire(0L, OperationType.READ);
        Assert.assertNotSame((Object)initialWindow, (Object)window);
        pool.close();
        file.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void handOverDirtyPersistenceRowToReaderShouldWriteWhenClosing() throws Exception {
        String filename = new File(target.makeGraphDbDir(), "dirty").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        int blockSize = 8;
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        final PersistenceWindowPool pool = new PersistenceWindowPool(new File("test.store"), 8, (StoreChannel)channel, 0L, false, false, new ConcurrentHashMap(), BrickElementFactory.DEFAULT, StringLogger.DEV_NULL);
        final PersistenceWindow t1Row = pool.acquire(0L, OperationType.WRITE);
        OtherThreadExecutor<Object> otherThread = new OtherThreadExecutor<Object>("other thread", null);
        Future<Throwable> future = otherThread.executeDontWait(new OtherThreadExecutor.WorkerCommand<Void, Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Throwable doWork(Void state) {
                PersistenceWindow t2Row = pool.acquire(0L, OperationType.READ);
                try {
                    Assert.assertTrue((t1Row == t2Row ? 1 : 0) != 0);
                    PersistenceWindowPoolTest.this.assertBufferContents(8, t2Row);
                    Throwable throwable = null;
                    return throwable;
                }
                catch (Throwable t) {
                    Throwable throwable = t;
                    return throwable;
                }
                finally {
                    pool.release(t2Row);
                }
            }
        });
        try {
            this.writeBufferContents(8, t1Row);
            otherThread.waitUntilWaiting();
        }
        finally {
            pool.release(t1Row);
        }
        Throwable failure = future.get();
        if (failure != null) {
            throw Exceptions.launderedException((Throwable)failure);
        }
        PersistenceWindow row = pool.acquire(0L, OperationType.READ);
        Assert.assertFalse((t1Row == row ? 1 : 0) != 0);
        this.assertBufferContents(8, row);
        pool.close();
        otherThread.close();
        file.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void releaseShouldUnlockWindowEvenIfExceptionIsThrown() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        PersistenceWindowPool pool = new PersistenceWindowPool(new File("test.store"), 8, (StoreChannel)channel, 0L, false, false, new ConcurrentHashMap(), BrickElementFactory.DEFAULT, StringLogger.DEV_NULL);
        PersistenceRow row = (PersistenceRow)Mockito.mock(PersistenceRow.class);
        Mockito.when((Object)row.writeOutAndCloseIfFree(false)).thenThrow(new Throwable[]{new UnderlyingStorageException("Unable to write record")});
        this.expectedUnderlyingException.expect(UnderlyingStorageException.class);
        try {
            pool.release((PersistenceWindow)row);
        }
        finally {
            ((PersistenceRow)Mockito.verify((Object)row)).unLock();
        }
        pool.close();
        file.close();
    }

    @Test
    public void brickSizeZeroShouldNotCauseNPEWhenOtherThreadLoadsPersistenceRow() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        PersistenceRow window = new PersistenceRow(0L, 10, (StoreChannel)channel);
        ConcurrentMap map = (ConcurrentMap)Mockito.mock(ConcurrentMap.class);
        Mockito.when(map.get(0L)).then(this.returnNullFirstTimeButAWindowSecondTime(window));
        Mockito.when((Object)map.putIfAbsent(Matchers.eq((long)0L), Matchers.any(PersistenceRow.class))).thenReturn((Object)window);
        PersistenceWindowPool pool = new PersistenceWindowPool(new File("test.store"), 8, (StoreChannel)channel, 0L, false, false, map, BrickElementFactory.DEFAULT, StringLogger.DEV_NULL);
        PersistenceWindow acquiredWindow = pool.acquire(0L, OperationType.READ);
        Assert.assertEquals((Object)window, (Object)acquiredWindow);
        pool.close();
        file.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSeeEqualNumberBrickLockAndUnlock() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        file.setLength(80L);
        final AtomicInteger lockedCount = new AtomicInteger();
        final AtomicInteger unlockedCount = new AtomicInteger();
        BrickElementFactory brickFactory = new BrickElementFactory(){

            public BrickElement create(final int index) {
                return new BrickElement(index){

                    synchronized void lock() {
                        Assert.assertEquals((long)0L, (long)index);
                        super.lock();
                        lockedCount.incrementAndGet();
                    }

                    void unLock() {
                        Assert.assertEquals((long)0L, (long)index);
                        super.unLock();
                        unlockedCount.incrementAndGet();
                    }
                };
            }
        };
        try (PersistenceWindowPool pool = new PersistenceWindowPool(new File("test.store"), 8, (StoreChannel)channel, 10000L, false, false, new ConcurrentHashMap(), brickFactory, StringLogger.DEV_NULL);){
            pool.release(pool.acquire(0L, OperationType.READ));
            Assert.assertEquals((long)1L, (long)lockedCount.get());
            Assert.assertEquals((long)1L, (long)unlockedCount.get());
        }
    }

    private Answer<PersistenceRow> returnNullFirstTimeButAWindowSecondTime(final PersistenceRow window) {
        return new Answer<PersistenceRow>(){
            int invocations = 0;

            public PersistenceRow answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (this.invocations++ == 0) {
                    return null;
                }
                return window;
            }
        };
    }

    private void writeBufferContents(int blockSize, PersistenceWindow t1Row) {
        Buffer buffer = t1Row.getBuffer();
        for (int i = 0; i < blockSize; ++i) {
            buffer.put((byte)i);
        }
    }

    private void assertBufferContents(int blockSize, PersistenceWindow row) {
        Buffer buffer = row.getBuffer();
        for (int i = 0; i < blockSize; ++i) {
            Assert.assertEquals((long)((byte)i), (long)buffer.get());
        }
    }
}

