/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Arrays;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.test.docs.DocsIncludeFile;

public class RecordSizesDocTest {
    @Rule
    public final DocsIncludeFile writer = DocsIncludeFile.inSection("ops");

    @Test
    public void record_sizes_table() throws Exception {
        this.writer.println("[options=\"header\",cols=\"<45,>20m,<35\", width=\"80%\"]");
        this.writer.println("|======================================");
        this.writer.println("| Store file  | Record size  | Contents");
        for (Store store : Arrays.asList(RecordSizesDocTest.store(".nodestore.db", 15, "Nodes"), RecordSizesDocTest.store(".relationshipstore.db", 34, "Relationships"), RecordSizesDocTest.store(".propertystore.db", 41, "Properties for nodes and relationships"), RecordSizesDocTest.dynamicStore(".propertystore.db.strings", (Setting<Integer>)StoreFactory.Configuration.string_block_size, "Values of string properties"), RecordSizesDocTest.dynamicStore(".propertystore.db.arrays", (Setting<Integer>)StoreFactory.Configuration.array_block_size, "Values of array properties"))) {
            this.writer.printf("| %s | %d B | %s%n", store.simpleFileName, store.recordSize, store.contentsDescription);
        }
        this.writer.println("|======================================");
        this.writer.println();
    }

    private static Store dynamicStore(String storeFileName, Setting<Integer> blockSizeSetting, String contentsDescription) {
        return RecordSizesDocTest.store(storeFileName, RecordSizesDocTest.defaultDynamicSize(blockSizeSetting), contentsDescription);
    }

    private static Store store(String storeFileName, int recordSize, String contentsDescription) {
        return new Store("neostore" + storeFileName, recordSize, contentsDescription);
    }

    private static int defaultDynamicSize(Setting<Integer> setting) {
        return 8 + Integer.parseInt(setting.getDefaultValue());
    }

    private static class Store {
        final String simpleFileName;
        final int recordSize;
        final String contentsDescription;

        Store(String simpleFileName, int recordSize, String contentsDescription) {
            this.simpleFileName = simpleFileName;
            this.recordSize = recordSize;
            this.contentsDescription = contentsDescription;
        }
    }
}

