/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.RecordSerializable;
import org.neo4j.kernel.impl.nioneo.store.RecordSerializer;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;

public class SchemaStoreTest {
    private Config config;
    private SchemaStore store;
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private StoreFactory storeFactory;

    @Test
    public void serializationAndDeserialization() throws Exception {
        int propertyKey = 4;
        int labelId = 1;
        IndexRule indexRule = IndexRule.indexRule((long)this.store.nextId(), (int)labelId, (int)propertyKey, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        byte[] serialized = new RecordSerializer().append((RecordSerializable)indexRule).serialize();
        IndexRule readIndexRule = (IndexRule)SchemaRule.Kind.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(serialized));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.getKind(), (Object)readIndexRule.getKind());
        Assert.assertEquals((long)indexRule.getLabel(), (long)readIndexRule.getLabel());
        Assert.assertEquals((long)indexRule.getPropertyKey(), (long)readIndexRule.getPropertyKey());
        Assert.assertEquals((Object)indexRule.getProviderDescriptor(), (Object)readIndexRule.getProviderDescriptor());
    }

    @Test
    public void storeAndLoadAllShortRules() throws Exception {
        List<SchemaRule> rules = Arrays.asList(IndexRule.indexRule((long)this.store.nextId(), (int)0, (int)5, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR), IndexRule.indexRule((long)this.store.nextId(), (int)1, (int)6, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR), IndexRule.indexRule((long)this.store.nextId(), (int)1, (int)7, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        for (SchemaRule rule : rules) {
            this.storeRule(rule);
        }
        Collection readRules = IteratorUtil.asCollection((Iterator)this.store.loadAllSchemaRules());
        Assert.assertEquals(rules, (Object)readRules);
    }

    private long storeRule(SchemaRule rule) {
        Collection records = this.store.allocateFrom(rule);
        for (DynamicRecord record : records) {
            this.store.updateRecord(record);
        }
        return ((DynamicRecord)IteratorUtil.first((Iterable)records)).getId();
    }

    @Before
    public void before() throws Exception {
        this.config = new Config(MapUtil.stringMap((String[])new String[0]));
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
        DefaultWindowPoolFactory windowPoolFactory = new DefaultWindowPoolFactory();
        this.storeFactory = new StoreFactory(this.config, (IdGeneratorFactory)idGeneratorFactory, (WindowPoolFactory)windowPoolFactory, (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
        File file = new File("schema-store");
        this.storeFactory.createSchemaStore(file);
        this.store = this.storeFactory.newSchemaStore(file);
    }

    @After
    public void after() throws Exception {
        this.store.close();
    }
}

