/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class StoreFactoryTest {
    @Test
    public void shouldHaveSameCreationTimeAndUpgradeTimeOnStartup() throws Exception {
        StoreFactory storeFactory = StoreFactoryTest.createStoreFactory();
        NeoStore neostore = storeFactory.createNeoStore(new File("neostore"));
        Assert.assertThat((Object)neostore.getUpgradeId(), (Matcher)CoreMatchers.equalTo((Object)neostore.getRandomNumber()));
        Assert.assertThat((Object)neostore.getUpgradeTime(), (Matcher)CoreMatchers.equalTo((Object)neostore.getCreationTime()));
    }

    private static StoreFactory createStoreFactory() {
        Map configParams = MapUtil.stringMap((String[])new String[]{CommonAbstractStore.Configuration.read_only.name(), "false", CommonAbstractStore.Configuration.backup_slave.name(), "false"});
        return new StoreFactory(new Config(configParams), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)new EphemeralFileSystemAbstraction(), StringLogger.DEV_NULL, (RemoteTxHook)Mockito.mock(RemoteTxHook.class));
    }
}

