/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;

public class StoreFileChannelTest {
    @Test
    public void shouldHandlePartialWrites() throws Exception {
        FileChannel mockChannel = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)mockChannel.write((ByteBuffer)Mockito.any(ByteBuffer.class), Mockito.anyLong())).thenReturn((Object)4);
        ByteBuffer buffer = ByteBuffer.wrap("Hello, world!".getBytes("UTF-8"));
        StoreFileChannel channel = new StoreFileChannel(mockChannel);
        channel.writeAll(buffer, 20L);
        ((FileChannel)Mockito.verify((Object)mockChannel)).write(buffer, 20L);
        ((FileChannel)Mockito.verify((Object)mockChannel)).write(buffer, 24L);
        ((FileChannel)Mockito.verify((Object)mockChannel)).write(buffer, 28L);
        ((FileChannel)Mockito.verify((Object)mockChannel)).write(buffer, 32L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChannel});
    }
}

