/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class StoreHighIdInflationTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    private final String storeDir = new File("dir").getAbsolutePath();

    @Test
    public void shouldFindActualHighIdWhenStartingOnInflatedStore() throws Exception {
        EphemeralFileSystemAbstraction fs = this.fsr.get();
        fs.mkdirs(new File(this.storeDir));
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(fs).newImpermanentDatabase(this.storeDir);
        long highestCreatedNodeId = this.createACoupleOfNodes((GraphDatabaseService)db, 3);
        long highestPropertyStringRecord = this.getHighestDynamicStringPropertyId(db);
        db.shutdown();
        this.inflateStore("NodeStore", 15, ".nodestore.db");
        this.inflateStore("StringPropertyStore", 8, ".nodestore.db");
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(fs).newImpermanentDatabase(this.storeDir);
        long nodeIdAfterInflation = this.createACoupleOfNodes((GraphDatabaseService)db, 1);
        long stringPropertyIdAfterInflation = this.getHighestDynamicStringPropertyId(db);
        db.shutdown();
        Assert.assertEquals((long)(highestCreatedNodeId + 1L), (long)nodeIdAfterInflation);
        Assert.assertEquals((long)(highestPropertyStringRecord + 1L), (long)stringPropertyIdAfterInflation);
    }

    private long getHighestDynamicStringPropertyId(GraphDatabaseAPI db) {
        return ((XaDataSourceManager)db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().getNeoStore().getPropertyStore().getStringStore().getHighestPossibleIdInUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflateStore(String trailerTypeDescriptor, int recordSize, String store) throws IOException {
        int trailerLength = UTF8.encode((String)CommonAbstractStore.buildTypeDescriptorAndVersion((String)trailerTypeDescriptor)).length;
        File neoStore = new File(this.storeDir, "neostore");
        File storeFile = new File(neoStore.getAbsolutePath() + store);
        EphemeralFileSystemAbstraction fs = this.fsr.get();
        try (StoreChannel channel = fs.open(storeFile, "rw");){
            channel.position(channel.size() - (long)trailerLength);
            channel.write(this.megabyteWorthOfZeros());
        }
        fs.deleteFile(new File(storeFile, ".id"));
    }

    private ByteBuffer megabyteWorthOfZeros() {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        while (buffer.hasRemaining()) {
            buffer.put((byte)0);
        }
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createACoupleOfNodes(GraphDatabaseService db, int count) {
        Transaction tx = db.beginTx();
        try {
            long last = 0L;
            for (int i = 0; i < count; ++i) {
                Node node = db.createNode();
                node.setProperty("key", (Object)"A very very very loooooooooooooooooooooooooooooooooooooooooooooong string that should spill over into a dynamic record");
                last = node.getId();
            }
            tx.success();
            long l = last;
            return l;
        }
        finally {
            tx.finish();
        }
    }
}

