/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;

public class StoreVersionTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void allStoresShouldHaveTheCurrentVersionIdentifier() throws IOException {
        CommonAbstractStore[] stores;
        File outputDir = new File("target/var/" + StoreVersionTest.class.getSimpleName());
        this.fs.get().mkdirs(outputDir);
        File storeFileName = new File(outputDir, "neostore");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.store_dir.name(), outputDir.getPath());
        config.put("neo_store", storeFileName.getPath());
        StoreFactory sf = new StoreFactory(new Config(config, new Class[]{GraphDatabaseSettings.class}), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, null);
        NeoStore neoStore = sf.createNeoStore(storeFileName);
        for (CommonAbstractStore store : stores = new CommonAbstractStore[]{neoStore.getNodeStore(), neoStore.getRelationshipStore(), neoStore.getRelationshipTypeStore(), neoStore.getPropertyStore(), neoStore.getPropertyKeyTokenStore()}) {
            Assert.assertThat((Object)store.getTypeAndVersionDescriptor(), (Matcher)CoreMatchers.containsString((String)"v0.A.3"));
        }
        neoStore.close();
    }

    @Test
    @Ignore
    public void shouldFailToCreateAStoreContainingOldVersionNumber() throws IOException {
        File outputDir = new File("target/var/" + StoreVersionTest.class.getSimpleName());
        Assert.assertTrue((boolean)outputDir.mkdirs());
        URL legacyStoreResource = StoreMigrator.class.getResource("legacystore/exampledb/neostore.nodestore.db");
        File workingFile = new File(outputDir, "neostore.nodestore.db");
        FileUtils.copyFile((File)new File(legacyStoreResource.getFile()), (File)workingFile);
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        try {
            new NodeStore(workingFile, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, null, StoreVersionMismatchHandler.THROW_EXCEPTION);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NotCurrentStoreVersionException e) {
            // empty catch block
        }
    }

    @Test
    public void neoStoreHasCorrectStoreVersionField() throws IOException {
        File outputDir = new File("target/var/" + StoreVersionTest.class.getSimpleName() + "test2");
        this.fs.get().mkdirs(outputDir);
        File storeFileName = new File(outputDir, "neostore");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.store_dir.name(), outputDir.getPath());
        config.put("neo_store", storeFileName.getPath());
        StoreFactory sf = new StoreFactory(new Config(config, new Class[]{GraphDatabaseSettings.class}), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, null);
        NeoStore neoStore = sf.createNeoStore(storeFileName);
        Assert.assertEquals((Object)"v0.A.3", (Object)NeoStore.versionLongToString((long)neoStore.getStoreVersion()));
        Assert.assertEquals((Object)"v0.A.3", (Object)NeoStore.versionLongToString((long)NeoStore.getStoreVersion((FileSystemAbstraction)this.fs.get(), (File)storeFileName)));
    }

    @Test
    public void testProperEncodingDecodingOfVersionString() {
        String[] toTest;
        for (String string : toTest = new String[]{"123", "foo", "0.9.9", "v0.A.0", "bar", "chris", "1234567"}) {
            Assert.assertEquals((Object)string, (Object)NeoStore.versionLongToString((long)NeoStore.versionStringToLong((String)string)));
        }
    }
}

