/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.impl.nioneo.store.ProduceUncleanStore;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.TargetDirectory;

public class TestBrokenStoreRecovery {
    private void trimFileToSize(File theFile, int toSize) throws IOException {
        FileChannel theChannel = new RandomAccessFile(theFile, "rw").getChannel();
        theChannel.truncate(toSize);
        theChannel.force(false);
        theChannel.close();
    }

    @Test
    public void testTruncatedPropertyStore() throws Exception {
        File storeDir = TargetDirectory.forTest(TestBrokenStoreRecovery.class).cleanDirectory("propertyStore");
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceUncleanStore.class.getName(), storeDir.getAbsolutePath()});
        Assert.assertEquals((long)0L, (long)new ProcessStreamHandler(process, true).waitForResult());
        this.trimFileToSize(new File(storeDir, "neostore.propertystore.db"), 42);
        File log = new File(storeDir, "nioneo_logical.log.1");
        this.trimFileToSize(log, 78);
        new GraphDatabaseFactory().newEmbeddedDatabase(storeDir.getAbsolutePath()).shutdown();
    }
}

