/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestGraphProperties {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private TestGraphDatabaseFactory factory;

    @Before
    public void before() throws Exception {
        this.factory = new TestGraphDatabaseFactory().setFileSystem(this.fs.get());
    }

    @Test
    public void basicProperties() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        PropertyContainer graphProperties = this.properties(db);
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty("test"))));
        Transaction tx = db.beginTx();
        graphProperties.setProperty("test", (Object)"yo");
        Assert.assertEquals((Object)"yo", (Object)graphProperties.getProperty("test"));
        tx.success();
        tx.finish();
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("test").withValue("yo")));
        tx = db.beginTx();
        Assert.assertNull((Object)graphProperties.removeProperty("something non existent"));
        Assert.assertEquals((Object)"yo", (Object)graphProperties.removeProperty("test"));
        Assert.assertNull((Object)graphProperties.getProperty("test", null));
        graphProperties.setProperty("other", (Object)10);
        Assert.assertEquals((Object)10, (Object)graphProperties.getProperty("other"));
        graphProperties.setProperty("new", (Object)"third");
        tx.success();
        tx.finish();
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty("test"))));
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("other").withValue(10)));
        Assert.assertThat(Neo4jMatchers.getPropertyKeys((GraphDatabaseService)db, graphProperties), Neo4jMatchers.containsOnly("other", "new"));
        tx = db.beginTx();
        graphProperties.setProperty("rollback", (Object)true);
        Assert.assertEquals((Object)true, (Object)graphProperties.getProperty("rollback"));
        tx.finish();
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty("rollback"))));
        db.shutdown();
    }

    @Test
    public void setManyGraphProperties() throws Exception {
        int i;
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Transaction tx = db.beginTx();
        Object[] values = new Object[]{10, "A string value", new float[]{1234.567f, 7654.321f}, "A rather longer string which wouldn't fit inlined #!)(&\u00a4"};
        int count = 200;
        for (i = 0; i < count; ++i) {
            this.properties(db).setProperty("key" + i, values[i % values.length]);
        }
        tx.success();
        tx.finish();
        for (i = 0; i < count; ++i) {
            Assert.assertThat((Object)this.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("key" + i).withValue(values[i % values.length])));
        }
        TestGraphProperties.nodeManager(db).clearCache();
        for (i = 0; i < count; ++i) {
            Assert.assertThat((Object)this.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("key" + i).withValue(values[i % values.length])));
        }
        db.shutdown();
    }

    private static NodeManager nodeManager(GraphDatabaseAPI db) {
        return (NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class);
    }

    @Test
    public void setBigArrayGraphProperty() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        long[] array = new long[1000];
        for (int i = 0; i < 10; ++i) {
            array[array.length / 10 * i] = i;
        }
        String key = "big long array";
        Transaction tx = db.beginTx();
        this.properties(db).setProperty(key, (Object)array);
        Assert.assertThat((Object)this.properties(db), (Matcher)Neo4jMatchers.hasProperty(key).withValue(array));
        tx.success();
        tx.finish();
        Assert.assertThat((Object)this.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key).withValue(array)));
        TestGraphProperties.nodeManager(db).clearCache();
        Assert.assertThat((Object)this.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key).withValue(array)));
        db.shutdown();
    }

    private PropertyContainer properties(GraphDatabaseAPI db) {
        return TestGraphProperties.nodeManager(db).getGraphProperties();
    }

    @Test
    public void firstRecordOtherThanZeroIfNotFirst() throws Exception {
        String storeDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("zero").getAbsolutePath();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase(storeDir);
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Yo");
        tx.success();
        tx.finish();
        db.shutdown();
        db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase(storeDir);
        tx = db.beginTx();
        TestGraphProperties.nodeManager(db).getGraphProperties().setProperty("test", (Object)"something");
        tx.success();
        tx.finish();
        db.shutdown();
        NeoStore neoStore = new StoreFactory(new Config(Collections.emptyMap(), new Class[]{GraphDatabaseSettings.class}), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, null).newNeoStore(new File(storeDir, "neostore"));
        long prop = neoStore.getGraphNextProp();
        Assert.assertTrue((prop != 0L ? 1 : 0) != 0);
        neoStore.close();
    }

    @Test
    public void graphPropertiesAreLockedPerTx() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Worker worker1 = new Worker("W1", new State(db));
        Worker worker2 = new Worker("W2", new State(db));
        GraphProperties properties = TestGraphProperties.getGraphProperties(db);
        worker1.beginTx();
        worker2.beginTx();
        String key1 = "name";
        String value1 = "Value 1";
        String key2 = "some other property";
        String value2 = "Value 2";
        String key3 = "say";
        String value3 = "hello";
        worker1.setProperty(key1, value1).get();
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key1))));
        Assert.assertFalse((boolean)worker2.hasProperty(key1));
        Future<Void> blockedSetProperty = worker2.setProperty(key2, value2);
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key1))));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key2))));
        worker1.setProperty(key3, value3).get();
        Assert.assertFalse((boolean)blockedSetProperty.isDone());
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key1))));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key2))));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key3))));
        worker1.commitTx();
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key1)));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key2))));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key3)));
        blockedSetProperty.get();
        Assert.assertTrue((boolean)blockedSetProperty.isDone());
        worker2.commitTx();
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key1).withValue(value1)));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key2).withValue(value2)));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key3).withValue(value3)));
        worker1.close();
        worker2.close();
        db.shutdown();
    }

    @Test
    public void upgradeDoesntAccidentallyAssignPropertyChainZero() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory().setFileSystem(fileSystem);
        String storeDir = new File("test").getAbsolutePath();
        GraphDatabaseAPI db = (GraphDatabaseAPI)factory.newImpermanentDatabase(storeDir);
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Something");
        tx.success();
        tx.finish();
        db.shutdown();
        this.truncateNeoStoreTo5Records(fileSystem, storeDir);
        db = (GraphDatabaseAPI)factory.newImpermanentDatabase(storeDir);
        GraphPropertiesImpl properties = TestGraphProperties.nodeManager(db).getGraphProperties();
        Assert.assertThat(Neo4jMatchers.getPropertyKeys((GraphDatabaseService)db, (PropertyContainer)properties), Neo4jMatchers.isEmpty());
        tx = db.beginTx();
        properties.setProperty("a property", (Object)"a value");
        tx.success();
        tx.finish();
        TestGraphProperties.nodeManager(db).clearCache();
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("a property").withValue("a value")));
        db.shutdown();
        db = (GraphDatabaseAPI)factory.newImpermanentDatabase(storeDir);
        properties = TestGraphProperties.nodeManager(db).getGraphProperties();
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("a property").withValue("a value")));
        db.shutdown();
        fileSystem.shutdown();
    }

    private void truncateNeoStoreTo5Records(FileSystemAbstraction fileSystem, String storeDir) throws IOException {
        File neoStoreFile = new File(storeDir, "neostore");
        StoreChannel channel = fileSystem.open(neoStoreFile, "rw");
        channel.position(81L);
        int trail = (int)(channel.size() - channel.position());
        ByteBuffer trailBuffer = null;
        if (trail > 0) {
            trailBuffer = ByteBuffer.allocate(trail);
            channel.read(trailBuffer);
            trailBuffer.flip();
        }
        channel.position(45L);
        if (trail > 0) {
            channel.write(trailBuffer);
        }
        channel.truncate(channel.position());
    }

    @Test
    public void twoUncleanInARow() throws Exception {
        String storeDir = "dir";
        EphemeralFileSystemAbstraction snapshot = this.produceUncleanStore(this.fs.get(), storeDir);
        snapshot = this.produceUncleanStore(snapshot, storeDir);
        snapshot = this.produceUncleanStore(snapshot, storeDir);
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(snapshot).newImpermanentDatabase(storeDir);
        Assert.assertThat((Object)TestGraphProperties.nodeManager(db).getGraphProperties(), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("prop").withValue("Some value")));
        db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEquals() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        GraphPropertiesImpl graphProperties = TestGraphProperties.nodeManager(db).getGraphProperties();
        Transaction tx = db.beginTx();
        try {
            graphProperties.setProperty("test", (Object)"test");
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertEquals((Object)graphProperties, (Object)TestGraphProperties.nodeManager(db).getGraphProperties());
        db.shutdown();
        db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Assert.assertFalse((boolean)graphProperties.equals(TestGraphProperties.nodeManager(db).getGraphProperties()));
    }

    private static GraphProperties getGraphProperties(GraphDatabaseAPI db) {
        return TestGraphProperties.nodeManager(db).getGraphProperties();
    }

    private EphemeralFileSystemAbstraction produceUncleanStore(EphemeralFileSystemAbstraction fileSystem, String storeDir) {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(fileSystem).newImpermanentDatabase(storeDir);
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Something");
        TestGraphProperties.nodeManager((GraphDatabaseAPI)db).getGraphProperties().setProperty("prop", (Object)"Some value");
        tx.success();
        tx.finish();
        EphemeralFileSystemAbstraction snapshot = fileSystem.snapshot();
        db.shutdown();
        return snapshot;
    }

    private static class Worker
    extends OtherThreadExecutor<State> {
        public Worker(String name, State initialState) {
            super(name, initialState);
        }

        public boolean hasProperty(final String key) throws Exception {
            return this.execute(new OtherThreadExecutor.WorkerCommand<State, Boolean>(){

                @Override
                public Boolean doWork(State state) {
                    return state.properties.hasProperty(key);
                }
            });
        }

        public void commitTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx.success();
                    state.tx.finish();
                    return null;
                }
            });
        }

        void beginTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx = state.db.beginTx();
                    return null;
                }
            });
        }

        Future<Void> setProperty(final String key, final Object value) throws Exception {
            return this.executeDontWait(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.properties.setProperty(key, value);
                    return null;
                }
            });
        }
    }

    private static class State {
        private final GraphDatabaseAPI db;
        private final PropertyContainer properties;
        private Transaction tx;

        State(GraphDatabaseAPI db) {
            this.db = db;
            this.properties = TestGraphProperties.getGraphProperties(db);
        }
    }
}

