/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class TestGrowingFileMemoryMapping {
    private static final int MEGA = 0x100000;

    @Test
    public void shouldGrowAFileWhileContinuingToMemoryMapNewRegions() throws Exception {
        Assume.assumeTrue((!Settings.osIsWindows() ? 1 : 0) != 0);
        int NUMBER_OF_RECORDS = 1000000;
        File storeDir = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.nodestore_mapped_memory_size.name(), this.mmapSize(NUMBER_OF_RECORDS, 15), CommonAbstractStore.Configuration.use_memory_mapped_buffers.name(), "true", CommonAbstractStore.Configuration.store_dir.name(), storeDir.getPath()}), new Class[]{NodeStore.Configuration.class});
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
        StoreFactory storeFactory = new StoreFactory(config, (IdGeneratorFactory)idGeneratorFactory, (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
        File fileName = new File(storeDir, "neostore.nodestore.db");
        storeFactory.createEmptyStore(fileName, storeFactory.buildTypeDescriptorAndVersion("NodeStore"));
        NodeStore nodeStore = new NodeStore(fileName, config, (IdGeneratorFactory)idGeneratorFactory, (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), StringLogger.DEV_NULL, null, StoreVersionMismatchHandler.THROW_EXCEPTION);
        for (int i = 0; i < 2 * NUMBER_OF_RECORDS; ++i) {
            NodeRecord record = new NodeRecord(nodeStore.nextId(), false, 0L, 0L);
            record.setInUse(true);
            nodeStore.updateRecord(record);
        }
        WindowPoolStats stats = nodeStore.getWindowPoolStats();
        nodeStore.close();
        Assert.assertEquals((String)stats.toString(), (long)0L, (long)stats.getMissCount());
    }

    private String mmapSize(int numberOfRecords, int recordSize) {
        int bytes = numberOfRecords * recordSize;
        if (bytes < 0x100000) {
            throw new IllegalArgumentException("too few records: " + numberOfRecords);
        }
        return bytes / 0x100000 + "M";
    }
}

