/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.LongerShortString;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.TestShortString;

public class TestLongerShortString {
    @Test
    public void testMasks() throws Exception {
        Assert.assertEquals((long)0L, (long)(1 & LongerShortString.invertedBitMask((LongerShortString[])new LongerShortString[]{LongerShortString.NUMERICAL})));
        Assert.assertEquals((long)0L, (long)(2 & LongerShortString.invertedBitMask((LongerShortString[])new LongerShortString[]{LongerShortString.DATE})));
        Assert.assertEquals((long)LongerShortString.NUMERICAL.bitMask(), (long)(3 & LongerShortString.invertedBitMask((LongerShortString[])new LongerShortString[]{LongerShortString.DATE})));
        Assert.assertEquals((long)0L, (long)((LongerShortString.NUMERICAL.bitMask() | LongerShortString.NUMERICAL.bitMask()) & LongerShortString.invertedBitMask((LongerShortString[])new LongerShortString[]{LongerShortString.NUMERICAL, LongerShortString.DATE})));
    }

    @Test
    public void canEncodeEmptyString() {
        this.assertCanEncodeAndDecodeToSame("");
    }

    @Test
    public void canEncodeNumerical() {
        this.assertCanEncodeAndDecodeToSame("12345678901234567890");
        this.assertCanEncodeAndDecodeToSame("12345678901234567890 +-.,' 321,3");
    }

    @Test
    public void canEncodeDate() throws Exception {
        this.assertCanEncodeAndDecodeToSame("2011-10-10 12:45:22+0200");
        this.assertCanEncodeAndDecodeToSame("2011/10/10 12:45:22+0200");
    }

    @Test
    public void testRandomStrings() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            for (TestShortString.Charset charset : TestShortString.Charset.values()) {
                List<String> list = TestShortString.randomStrings(100, charset, 30);
                for (String string : list) {
                    PropertyBlock record;
                    if (!LongerShortString.encode((int)10, (String)string, (PropertyBlock)(record = new PropertyBlock()), (int)32)) continue;
                    Assert.assertEquals((Object)string, (Object)LongerShortString.decode((PropertyBlock)record));
                }
            }
        }
    }

    @Test
    public void canEncodeEmailAndUri() throws Exception {
        this.assertCanEncodeAndDecodeToSame("mattias@neotechnology.com");
        this.assertCanEncodeAndDecodeToSame("http://domain:7474/");
    }

    @Test
    public void canEncodeLower() throws Exception {
        this.assertCanEncodeAndDecodeToSame("folder/generators/templates/controller.ext");
        this.assertCanEncodeAndDecodeToSame("folder/generators/templates/controller.extr");
        this.assertCannotEncode("folder/generators/templates/controller.extra");
    }

    @Test
    public void canEncodeLowerHex() throws Exception {
        this.assertCanEncodeAndDecodeToSame("da39a3ee5e6b4b0d3255bfef95601890afd80709");
        this.assertCanEncodeAndDecodeToSame("0123456789abcdefabcd0a0b0c0d0e1a1b1c1d1ef9e8d7c6b5a4f3");
        this.assertCannotEncode("da39a3ee5e6b4b0d3255bfef95601890afd807090123456789abcde");
        this.assertCannotEncode("aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeex");
    }

    @Test
    public void canEncodeUpperHex() throws Exception {
        this.assertCanEncodeAndDecodeToSame("DA39A3EE5E6B4B0D3255BFEF95601890AFD80709");
        this.assertCanEncodeAndDecodeToSame("0123456789ABCDEFABCD0A0B0C0D0E1A1B1C1D1EF9E8D7C6B5A4F3");
        this.assertCannotEncode("DA39A3EE5E6B4B0D3255BFEF95601890AFD807090123456789ABCDE");
        this.assertCannotEncode("AAAAAAAAAABBBBBBBBBBCCCCCCCCCCDDDDDDDDDDEEEEEEEEEEX");
    }

    @Test
    public void checkMarginalFit() throws Exception {
        this.assertCanEncodeAndDecodeToSame("^aaaaaaaaaaaaaaaaaaaaaaaaaa");
        this.assertCannotEncode("^aaaaaaaaaaaaaaaaaaaaaaaaaaa");
    }

    @Test
    public void canEncodeUUIDString() throws Exception {
        this.assertCanEncodeAndDecodeToSame("81fe144f-484b-4a34-8e36-17a021540318");
    }

    private void assertCanEncodeAndDecodeToSame(String string) {
        this.assertCanEncodeAndDecodeToSame(string, 32);
    }

    private void assertCanEncodeAndDecodeToSame(String string, int payloadSize) {
        PropertyBlock target = new PropertyBlock();
        Assert.assertTrue((boolean)LongerShortString.encode((int)0, (String)string, (PropertyBlock)target, (int)payloadSize));
        Assert.assertEquals((Object)string, (Object)LongerShortString.decode((PropertyBlock)target));
    }

    private void assertCannotEncode(String string) {
        this.assertCannotEncode(string, 32);
    }

    private void assertCannotEncode(String string, int payloadSize) {
        Assert.assertFalse((boolean)LongerShortString.encode((int)0, (String)string, (PropertyBlock)new PropertyBlock(), (int)payloadSize));
    }
}

