/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.scan.InMemoryLabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.PlaceboTm;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestNeoStore {
    private PropertyStore pStore;
    private RelationshipTypeTokenStore rtStore;
    private NeoStoreXaDataSource ds;
    private NeoStoreXaConnection xaCon;
    private TargetDirectory targetDirectory;
    private File path;
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());
    private Xid dummyXid;
    private byte txCount = 0;
    XAResource xaResource;

    private File file(String name) {
        return new File(this.path, name);
    }

    @Before
    public void setUpNeoStore() throws Exception {
        this.targetDirectory = TargetDirectory.forTest(this.fs.get(), this.getClass());
        this.path = this.targetDirectory.cleanDirectory("dir");
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, null);
        sf.createNeoStore(this.file("neostore")).close();
    }

    private Token createDummyIndex(int id, String key) {
        MyPropertyKeyToken index = new MyPropertyKeyToken(key, id);
        MyPropertyKeyToken.add(index);
        return index;
    }

    private void initializeStores() throws IOException {
        LockManagerImpl lockManager = new LockManagerImpl(new RagManager());
        Config config = new Config(MapUtil.stringMap((String[])new String[]{InternalAbstractGraphDatabase.Configuration.store_dir.name(), this.path.getPath(), InternalAbstractGraphDatabase.Configuration.neo_store.name(), "neo", InternalAbstractGraphDatabase.Configuration.logical_log.name(), this.file("nioneo_logical.log").getPath()}), new Class[]{GraphDatabaseSettings.class});
        EphemeralFileSystemAbstraction fs = this.fs.get();
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)fs, StringLogger.DEV_NULL, null);
        KernelHealth kernelHealth = (KernelHealth)Mockito.mock(KernelHealth.class);
        NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        List<Cache> caches = Arrays.asList((Cache)Mockito.mock(AutoLoadingCache.class), (Cache)Mockito.mock(AutoLoadingCache.class));
        Mockito.when((Object)nodeManager.caches()).thenReturn(caches);
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Locks.Client lockClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)lockClient);
        this.ds = new NeoStoreXaDataSource(config, (LockService)new ReentrantLockService(), sf, StringLogger.DEV_NULL, new XaFactory(config, TxIdGenerator.DEFAULT, (AbstractTransactionManager)new PlaceboTm((LockManager)lockManager, TxIdGenerator.DEFAULT), (FileSystemAbstraction)fs, new Monitors(), DevNullLoggingService.DEV_NULL, RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING, kernelHealth), TransactionStateFactory.noStateFactory((Logging)DevNullLoggingService.DEV_NULL), new TransactionInterceptorProviders(Collections.emptyList(), (DependencyResolver)this.dependencyResolverForConfig(config)), null, (Logging)new DevNullLoggingService(), (UpdateableSchemaState)new KernelSchemaStateStore(), (TokenNameLookup)Mockito.mock(TokenNameLookup.class), this.dependencyResolverForNoIndexProvider(nodeManager), (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class), (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class), (LabelTokenHolder)Mockito.mock(LabelTokenHolder.class), (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class), (PersistenceManager)Mockito.mock(PersistenceManager.class), (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), (TransactionEventHandlers)Mockito.mock(TransactionEventHandlers.class), IndexingService.NO_MONITOR, (FileSystemAbstraction)fs, (Function)new Function<NeoStore, Function<List<LogEntry>, List<LogEntry>>>(){

            public Function<List<LogEntry>, List<LogEntry>> apply(NeoStore neoStore) {
                return Functions.identity();
            }
        }, (StoreUpgrader)Mockito.mock(StoreUpgrader.class));
        this.ds.init();
        this.ds.start();
        this.xaCon = this.ds.getXaConnection();
        this.pStore = this.xaCon.getPropertyStore();
        this.rtStore = this.xaCon.getRelationshipTypeStore();
    }

    private DependencyResolver dependencyResolverForNoIndexProvider(final NodeManager nodeManager) {
        return new DependencyResolver.Adapter(){
            private final LabelScanStoreProvider labelScanStoreProvider = new LabelScanStoreProvider((LabelScanStore)new InMemoryLabelScanStore(), 10);

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (SchemaIndexProvider.class.isAssignableFrom(type)) {
                    return type.cast(SchemaIndexProvider.NO_INDEX_PROVIDER);
                }
                if (NodeManager.class.isAssignableFrom(type)) {
                    return type.cast(nodeManager);
                }
                if (LabelScanStoreProvider.class.isAssignableFrom(type)) {
                    return type.cast(this.labelScanStoreProvider);
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }

    private DependencyResolver.Adapter dependencyResolverForConfig(final Config config) {
        return new DependencyResolver.Adapter(){

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
                return type.cast(config);
            }
        };
    }

    private void startTx() throws XAException {
        this.dummyXid = new XidImpl(new byte[this.txCount], new byte[this.txCount]);
        this.txCount = (byte)(this.txCount + 1);
        this.xaResource = this.xaCon.getXaResource();
        this.xaResource.start(this.dummyXid, 0);
    }

    private void commitTx() throws XAException {
        this.xaResource.end(this.dummyXid, 0x4000000);
        this.xaResource.commit(this.dummyXid, true);
    }

    @After
    public void tearDownNeoStore() {
        for (String file : new String[]{"neo", "neo.nodestore.db", "neo.nodestore.db.labels", "neo.propertystore.db", "neo.propertystore.db.index", "neo.propertystore.db.index.keys", "neo.propertystore.db.strings", "neo.propertystore.db.arrays", "neo.relationshipstore.db", "neo.relationshiptypestore.db", "neo.relationshiptypestore.db.names", "neo.schemastore.db"}) {
            this.fs.get().deleteFile(this.file(file));
            this.fs.get().deleteFile(this.file(file + ".id"));
        }
        File file = new File(".");
        for (File nioFile : this.fs.get().listFiles(file)) {
            if (!nioFile.getName().startsWith("nioneo_logical.log")) continue;
            this.fs.get().deleteFile(nioFile);
        }
    }

    private int index(String key) {
        Iterator<Token> itr = MyPropertyKeyToken.index(key).iterator();
        if (!itr.hasNext()) {
            int id = (int)this.ds.nextId(PropertyKeyTokenRecord.class);
            this.createDummyIndex(id, key);
            this.xaCon.getTransaction().createPropertyKeyToken(key, id);
            return id;
        }
        return itr.next().id();
    }

    @Test
    public void testCreateNeoStore() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node2);
        DefinedProperty n1prop1 = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        DefinedProperty n1prop2 = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop2"), (Object)1);
        DefinedProperty n1prop3 = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop3"), (Object)true);
        DefinedProperty n2prop1 = this.xaCon.getTransaction().nodeAddProperty(node2, this.index("prop1"), (Object)"string2");
        DefinedProperty n2prop2 = this.xaCon.getTransaction().nodeAddProperty(node2, this.index("prop2"), (Object)2);
        DefinedProperty n2prop3 = this.xaCon.getTransaction().nodeAddProperty(node2, this.index("prop3"), (Object)false);
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        String typeName1 = "relationshiptype1";
        this.xaCon.getTransaction().createRelationshipTypeToken(relType1, typeName1);
        int relType2 = (int)this.ds.nextId(RelationshipType.class);
        String typeName2 = "relationshiptype2";
        this.xaCon.getTransaction().createRelationshipTypeToken(relType2, typeName2);
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel1, relType1, node1, node2);
        long rel2 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel2, relType2, node2, node1);
        DefinedProperty r1prop1 = this.xaCon.getTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        DefinedProperty r1prop2 = this.xaCon.getTransaction().relAddProperty(rel1, this.index("prop2"), (Object)1);
        DefinedProperty r1prop3 = this.xaCon.getTransaction().relAddProperty(rel1, this.index("prop3"), (Object)true);
        DefinedProperty r2prop1 = this.xaCon.getTransaction().relAddProperty(rel2, this.index("prop1"), (Object)"string2");
        DefinedProperty r2prop2 = this.xaCon.getTransaction().relAddProperty(rel2, this.index("prop2"), (Object)2);
        DefinedProperty r2prop3 = this.xaCon.getTransaction().relAddProperty(rel2, this.index("prop3"), (Object)false);
        this.commitTx();
        this.ds.stop();
        this.initializeStores();
        this.startTx();
        this.validateNodeRel1(node1, n1prop1, n1prop2, n1prop3, rel1, rel2, relType1, relType2);
        this.validateNodeRel2(node2, n2prop1, n2prop2, n2prop3, rel1, rel2, relType1, relType2);
        this.validateRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.validateRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.commitTx();
        this.ds.stop();
        this.initializeStores();
        this.startTx();
        this.deleteRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.deleteRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.deleteNode1(node1, n1prop1, n1prop2, n1prop3);
        this.deleteNode2(node2, n2prop1, n2prop2, n2prop3);
        this.commitTx();
        this.ds.stop();
        this.initializeStores();
        this.startTx();
        Assert.assertNull((Object)this.xaCon.getTransaction().nodeLoadLight(node1));
        Assert.assertNull((Object)this.xaCon.getTransaction().nodeLoadLight(node2));
        this.testGetRels(new long[]{rel1, rel2});
        long[] nodeIds = new long[10];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.xaCon.getTransaction().nodeCreate(nodeIds[i]);
            this.xaCon.getTransaction().nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            long id = this.ds.nextId(Relationship.class);
            this.xaCon.getTransaction().relationshipCreate(id, relType1, nodeIds[i], nodeIds[i + 1]);
            this.xaCon.getTransaction().relDelete(id);
        }
        for (i = 0; i < 3; ++i) {
            MutableRelationshipLoadingPosition pos = this.getPosition(this.xaCon, nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(this.xaCon, nodeIds[i], pos)) {
                this.xaCon.getTransaction().relDelete(rel.getId());
            }
            this.xaCon.getTransaction().nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    private MutableRelationshipLoadingPosition getPosition(NeoStoreXaConnection xaCon, long node) {
        return new MutableRelationshipLoadingPosition(xaCon.getTransaction().getRelationshipChainPosition(node));
    }

    private Iterable<RelationshipRecord> getMore(NeoStoreXaConnection xaCon, long node, MutableRelationshipLoadingPosition position) {
        Pair rels = xaCon.getTransaction().getMoreRelationships(node, (RelationshipLoadingPosition)position, RelIdArray.DirectionWrapper.BOTH, new int[0]);
        ArrayList list = new ArrayList();
        for (Map.Entry entry : ((Map)rels.first()).entrySet()) {
            list.add(entry.getValue());
        }
        position.setActual((RelationshipLoadingPosition)rels.other());
        return new CombiningIterable(list);
    }

    private void validateNodeRel1(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException {
        Iterable<RelationshipRecord> relData;
        NodeRecord nodeRecord = this.xaCon.getTransaction().nodeLoadLight(node);
        Assert.assertTrue((nodeRecord != null ? 1 : 0) != 0);
        ArrayMap props = new ArrayMap();
        NeoStoreTransaction.PropertyReceiver receiver = this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props);
        this.xaCon.getTransaction().nodeLoadProperties(node, false, receiver);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value());
                this.xaCon.getTransaction().nodeChangeProperty(node, prop1.propertyKeyId(), (Object)"-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value());
                this.xaCon.getTransaction().nodeChangeProperty(node, prop2.propertyKeyId(), (Object)new Integer(-1));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.xaCon.getTransaction().nodeChangeProperty(node, prop3.propertyKeyId(), (Object)false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        MutableRelationshipLoadingPosition pos = this.getPosition(this.xaCon, node);
        while ((relData = this.getMore(this.xaCon, node, pos)).iterator().hasNext()) {
            for (RelationshipRecord rel : relData) {
                if (rel.getId() == rel1) {
                    Assert.assertEquals((long)node, (long)rel.getFirstNode());
                    Assert.assertEquals((long)relType1, (long)rel.getType());
                } else if (rel.getId() == rel2) {
                    Assert.assertEquals((long)node, (long)rel.getSecondNode());
                    Assert.assertEquals((long)relType2, (long)rel.getType());
                } else {
                    throw new IOException();
                }
                ++count;
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private NeoStoreTransaction.PropertyReceiver newPropertyReceiver(final ArrayMap<Integer, Pair<DefinedProperty, Long>> props) {
        return new NeoStoreTransaction.PropertyReceiver(){

            public void receive(DefinedProperty property, long propertyRecordId) {
                props.put((Object)property.propertyKeyId(), (Object)Pair.of((Object)property, (Object)propertyRecordId));
            }
        };
    }

    private void validateNodeRel2(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException {
        Iterable<RelationshipRecord> relData;
        NodeRecord nodeRecord = this.xaCon.getTransaction().nodeLoadLight(node);
        Assert.assertTrue((nodeRecord != null ? 1 : 0) != 0);
        ArrayMap props = new ArrayMap();
        this.xaCon.getTransaction().nodeLoadProperties(node, false, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value());
                this.xaCon.getTransaction().nodeChangeProperty(node, prop1.propertyKeyId(), (Object)"-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value());
                this.xaCon.getTransaction().nodeChangeProperty(node, prop2.propertyKeyId(), (Object)new Integer(-2));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.xaCon.getTransaction().nodeChangeProperty(node, prop3.propertyKeyId(), (Object)true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        MutableRelationshipLoadingPosition pos = this.getPosition(this.xaCon, node);
        while ((relData = this.getMore(this.xaCon, node, pos)).iterator().hasNext()) {
            for (RelationshipRecord rel : relData) {
                if (rel.getId() == rel1) {
                    Assert.assertEquals((long)node, (long)rel.getSecondNode());
                    Assert.assertEquals((long)relType1, (long)rel.getType());
                } else if (rel.getId() == rel2) {
                    Assert.assertEquals((long)node, (long)rel.getFirstNode());
                    Assert.assertEquals((long)relType2, (long)rel.getType());
                } else {
                    throw new IOException();
                }
                ++count;
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private void validateRel1(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.xaCon.getTransaction().relLoadProperties(rel, false, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value());
                this.xaCon.getTransaction().relChangeProperty(rel, prop1.propertyKeyId(), (Object)"-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value());
                this.xaCon.getTransaction().relChangeProperty(rel, prop2.propertyKeyId(), (Object)new Integer(-1));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.xaCon.getTransaction().relChangeProperty(rel, prop3.propertyKeyId(), (Object)false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        RelationshipRecord relData = this.xaCon.getTransaction().relLoadLight(rel);
        Assert.assertEquals((long)firstNode, (long)relData.getFirstNode());
        Assert.assertEquals((long)secondNode, (long)relData.getSecondNode());
        Assert.assertEquals((long)relType, (long)relData.getType());
    }

    private void validateRel2(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.xaCon.getTransaction().relLoadProperties(rel, false, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value());
                this.xaCon.getTransaction().relChangeProperty(rel, prop1.propertyKeyId(), (Object)"-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value());
                this.xaCon.getTransaction().relChangeProperty(rel, prop2.propertyKeyId(), (Object)new Integer(-2));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.xaCon.getTransaction().relChangeProperty(rel, prop3.propertyKeyId(), (Object)true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        RelationshipRecord relData = this.xaCon.getTransaction().relLoadLight(rel);
        Assert.assertEquals((long)firstNode, (long)relData.getFirstNode());
        Assert.assertEquals((long)secondNode, (long)relData.getSecondNode());
        Assert.assertEquals((long)relType, (long)relData.getType());
    }

    private void validateRelTypes(int relType1, int relType2) throws IOException {
        Token data = this.rtStore.getToken(relType1);
        Assert.assertEquals((long)relType1, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype1", (Object)data.name());
        data = this.rtStore.getToken(relType2);
        Assert.assertEquals((long)relType2, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype2", (Object)data.name());
        Token[] allData = this.rtStore.getTokens(Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)allData.length);
        for (int i = 0; i < 2; ++i) {
            if (allData[i].id() == relType1) {
                Assert.assertEquals((long)relType1, (long)allData[i].id());
                Assert.assertEquals((Object)"relationshiptype1", (Object)allData[i].name());
                continue;
            }
            if (allData[i].id() == relType2) {
                Assert.assertEquals((long)relType2, (long)allData[i].id());
                Assert.assertEquals((Object)"relationshiptype2", (Object)allData[i].name());
                continue;
            }
            throw new IOException();
        }
    }

    private void deleteRel1(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.xaCon.getTransaction().relLoadProperties(rel, false, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.xaCon.getTransaction().relRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.xaCon.getTransaction().relLoadProperties(rel, false, (NeoStoreTransaction.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        RelationshipRecord relData = this.xaCon.getTransaction().relLoadLight(rel);
        Assert.assertEquals((long)firstNode, (long)relData.getFirstNode());
        Assert.assertEquals((long)secondNode, (long)relData.getSecondNode());
        Assert.assertEquals((long)relType, (long)relData.getType());
        this.xaCon.getTransaction().relDelete(rel);
        MutableRelationshipLoadingPosition firstPos = this.getPosition(this.xaCon, firstNode);
        Iterator<RelationshipRecord> first = this.getMore(this.xaCon, firstNode, firstPos).iterator();
        first.next();
        MutableRelationshipLoadingPosition secondPos = this.getPosition(this.xaCon, secondNode);
        Iterator<RelationshipRecord> second = this.getMore(this.xaCon, secondNode, secondPos).iterator();
        second.next();
        Assert.assertTrue((boolean)first.hasNext());
        Assert.assertTrue((boolean)second.hasNext());
    }

    private void deleteRel2(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.xaCon.getTransaction().relLoadProperties(rel, false, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.xaCon.getTransaction().relRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.xaCon.getTransaction().relLoadProperties(rel, false, (NeoStoreTransaction.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        RelationshipRecord relData = this.xaCon.getTransaction().relLoadLight(rel);
        Assert.assertEquals((long)firstNode, (long)relData.getFirstNode());
        Assert.assertEquals((long)secondNode, (long)relData.getSecondNode());
        Assert.assertEquals((long)relType, (long)relData.getType());
        this.xaCon.getTransaction().relDelete(rel);
        MutableRelationshipLoadingPosition firstPos = this.getPosition(this.xaCon, firstNode);
        Iterator<RelationshipRecord> first = this.getMore(this.xaCon, firstNode, firstPos).iterator();
        MutableRelationshipLoadingPosition secondPos = this.getPosition(this.xaCon, secondNode);
        Iterator<RelationshipRecord> second = this.getMore(this.xaCon, secondNode, secondPos).iterator();
        Assert.assertTrue((boolean)first.hasNext());
        Assert.assertTrue((boolean)second.hasNext());
    }

    private void deleteNode1(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3) throws IOException {
        ArrayMap props = new ArrayMap();
        this.xaCon.getTransaction().nodeLoadProperties(node, false, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.xaCon.getTransaction().nodeRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.xaCon.getTransaction().nodeLoadProperties(node, false, (NeoStoreTransaction.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        MutableRelationshipLoadingPosition pos = this.getPosition(this.xaCon, node);
        Iterator<RelationshipRecord> rels = this.getMore(this.xaCon, node, pos).iterator();
        Assert.assertTrue((boolean)rels.hasNext());
        this.xaCon.getTransaction().nodeDelete(node);
    }

    private void deleteNode2(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3) throws IOException {
        ArrayMap props = new ArrayMap();
        this.xaCon.getTransaction().nodeLoadProperties(node, false, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.xaCon.getTransaction().nodeRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.xaCon.getTransaction().nodeLoadProperties(node, false, (NeoStoreTransaction.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        MutableRelationshipLoadingPosition pos = this.getPosition(this.xaCon, node);
        Iterator<RelationshipRecord> rels = this.getMore(this.xaCon, node, pos).iterator();
        Assert.assertTrue((boolean)rels.hasNext());
        this.xaCon.getTransaction().nodeDelete(node);
    }

    private void testGetRels(long[] relIds) {
        for (long relId : relIds) {
            Assert.assertEquals(null, (Object)this.xaCon.getTransaction().relLoadLight(relId));
        }
    }

    @Test
    public void testRels1() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.xaCon.getTransaction().createRelationshipTypeToken(relType1, typeName);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.xaCon.getTransaction().nodeCreate(nodeIds[i]);
            this.xaCon.getTransaction().nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.xaCon.getTransaction().relationshipCreate(this.ds.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            MutableRelationshipLoadingPosition pos = this.getPosition(this.xaCon, nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(this.xaCon, nodeIds[i], pos)) {
                this.xaCon.getTransaction().relDelete(rel.getId());
            }
            this.xaCon.getTransaction().nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    @Ignore
    public void testRels2() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.xaCon.getTransaction().createRelationshipTypeToken(relType1, typeName);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.xaCon.getTransaction().nodeCreate(nodeIds[i]);
            this.xaCon.getTransaction().nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.xaCon.getTransaction().relationshipCreate(this.ds.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.xaCon.getTransaction().relationshipCreate(this.ds.nextId(Relationship.class), relType1, nodeIds[0], nodeIds[2]);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            MutableRelationshipLoadingPosition pos = this.getPosition(this.xaCon, nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(this.xaCon, nodeIds[i], pos)) {
                this.xaCon.getTransaction().relDelete(rel.getId());
            }
            this.xaCon.getTransaction().nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testRels3() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getTransaction().createRelationshipTypeToken(relType1, "relationshiptype1");
        long[] nodeIds = new long[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.xaCon.getTransaction().nodeCreate(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.xaCon.getTransaction().relationshipCreate(this.ds.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i * 2]);
        }
        long rel5 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel5, relType1, nodeIds[0], nodeIds[5]);
        long rel2 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel2, relType1, nodeIds[1], nodeIds[2]);
        long rel3 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel3, relType1, nodeIds[1], nodeIds[3]);
        long rel6 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel6, relType1, nodeIds[1], nodeIds[6]);
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel1, relType1, nodeIds[0], nodeIds[1]);
        long rel4 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel4, relType1, nodeIds[0], nodeIds[4]);
        long rel7 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel7, relType1, nodeIds[0], nodeIds[7]);
        this.commitTx();
        this.startTx();
        this.xaCon.getTransaction().relDelete(rel7);
        this.xaCon.getTransaction().relDelete(rel4);
        this.xaCon.getTransaction().relDelete(rel1);
        this.xaCon.getTransaction().relDelete(rel6);
        this.xaCon.getTransaction().relDelete(rel3);
        this.xaCon.getTransaction().relDelete(rel2);
        this.xaCon.getTransaction().relDelete(rel5);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testProps1() throws Exception {
        this.initializeStores();
        this.startTx();
        long nodeId = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(nodeId);
        this.pStore.nextId();
        DefinedProperty prop = this.xaCon.getTransaction().nodeAddProperty(nodeId, this.index("nisse"), (Object)new Integer(10));
        this.commitTx();
        this.ds.stop();
        this.initializeStores();
        this.startTx();
        this.xaCon.getTransaction().nodeChangeProperty(nodeId, prop.propertyKeyId(), (Object)new Integer(5));
        this.xaCon.getTransaction().nodeRemoveProperty(nodeId, prop.propertyKeyId());
        this.xaCon.getTransaction().nodeDelete(nodeId);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testSetBlockSize() throws Exception {
        this.targetDirectory.cleanup();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"string_block_size", "62", "array_block_size", "302"}), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, null);
        sf.createNeoStore(this.file("neo")).close();
        this.initializeStores();
        Assert.assertEquals((long)70L, (long)this.pStore.getStringBlockSize());
        Assert.assertEquals((long)310L, (long)this.pStore.getArrayBlockSize());
        this.ds.stop();
    }

    @Test
    public void setVersion() throws Exception {
        String storeDir = "target/test-data/set-version";
        new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(storeDir).shutdown();
        Assert.assertEquals((long)1L, (long)NeoStore.setVersion((FileSystemAbstraction)this.fs.get(), (File)new File(storeDir, "neostore"), (long)10L));
        Assert.assertEquals((long)10L, (long)NeoStore.setVersion((FileSystemAbstraction)this.fs.get(), (File)new File(storeDir, "neostore"), (long)12L));
        StoreFactory sf = new StoreFactory(new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class}), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, null);
        NeoStore neoStore = sf.newNeoStore(new File(storeDir, "neostore"));
        Assert.assertEquals((long)12L, (long)neoStore.getVersion());
        neoStore.close();
    }

    @Test
    public void testSetLatestConstraintTx() throws Exception {
        new GraphDatabaseFactory().newEmbeddedDatabase(this.testDir.absolutePath()).shutdown();
        StoreFactory sf = new StoreFactory(new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class}), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), StringLogger.DEV_NULL, null);
        NeoStore neoStore = sf.newNeoStore(new File(this.testDir.absolutePath(), "neostore"));
        Assert.assertEquals((long)0L, (long)neoStore.getLatestConstraintIntroducingTx());
        neoStore.setLatestConstraintIntroducingTx(10L);
        Assert.assertEquals((long)10L, (long)neoStore.getLatestConstraintIntroducingTx());
        neoStore.flushAll();
        neoStore.close();
        neoStore = sf.newNeoStore(new File(this.testDir.absolutePath(), "neostore"));
        Assert.assertEquals((long)10L, (long)neoStore.getLatestConstraintIntroducingTx());
        neoStore.close();
    }

    private static class CountingPropertyReceiver
    implements NeoStoreTransaction.PropertyReceiver {
        private int count;

        private CountingPropertyReceiver() {
        }

        public void receive(DefinedProperty property, long propertyRecordId) {
            ++this.count;
        }
    }

    private static class MutableRelationshipLoadingPosition
    implements RelationshipLoadingPosition {
        private RelationshipLoadingPosition actual;

        MutableRelationshipLoadingPosition(RelationshipLoadingPosition actual) {
            this.actual = actual;
        }

        void setActual(RelationshipLoadingPosition actual) {
            this.actual = actual;
        }

        public void updateFirst(long first) {
            this.actual.updateFirst(first);
        }

        public long position(RelIdArray.DirectionWrapper direction, int[] types) {
            return this.actual.position(direction, types);
        }

        public long nextPosition(long position, RelIdArray.DirectionWrapper direction, int[] types) {
            return this.actual.nextPosition(position, direction, types);
        }

        public boolean hasMore(RelIdArray.DirectionWrapper direction, int[] types) {
            return this.actual.hasMore(direction, types);
        }

        public void compareAndAdvance(long relIdDeleted, long nextRelId) {
            this.actual.compareAndAdvance(relIdDeleted, nextRelId);
        }

        public RelationshipLoadingPosition clone() {
            return this.actual.clone();
        }
    }

    private static class MyPropertyKeyToken
    extends Token {
        private static Map<String, Token> stringToIndex = new HashMap<String, Token>();
        private static Map<Integer, Token> intToIndex = new HashMap<Integer, Token>();

        protected MyPropertyKeyToken(String key, int keyId) {
            super(key, keyId);
        }

        public static Iterable<Token> index(String key) {
            if (stringToIndex.containsKey(key)) {
                return Arrays.asList(stringToIndex.get(key));
            }
            return Collections.emptyList();
        }

        public static Token getIndexFor(int index) {
            return intToIndex.get(index);
        }

        public static void add(MyPropertyKeyToken index) {
            stringToIndex.put(index.name(), index);
            intToIndex.put(index.id(), index);
        }
    }
}

