/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class TestPropertyKey {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lazyLoadWithinWriteTransaction() throws Exception {
        File dir = new File("dir");
        BatchInserter inserter = BatchInserters.inserter((String)dir.getPath(), (FileSystemAbstraction)this.fs.get());
        int count = 3000;
        long nodeId = inserter.createNode(this.mapWithManyProperties(count), new Label[0]);
        inserter.shutdown();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(dir.getPath());
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            Node node = db.getNodeById(nodeId);
            Assert.assertEquals((long)count, (long)IteratorUtil.count((Iterable)node.getPropertyKeys()));
            tx.success();
        }
        finally {
            tx.finish();
            db.shutdown();
        }
    }

    private Map<String, Object> mapWithManyProperties(int count) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < count; ++i) {
            properties.put("key:" + i, "value");
        }
        return properties;
    }
}

