/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class TestRelationshipGroupStore {
    private File directory;
    private String neostoreFileName;
    private int defaultThreshold;
    private FileSystemAbstraction fs;
    private GraphDatabaseAPI db;

    @Before
    public void before() throws Exception {
        this.directory = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
        this.neostoreFileName = new File(this.directory, "neostore").getAbsolutePath();
        this.defaultThreshold = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
    }

    @Test
    public void createWithDefaultThreshold() throws Exception {
        this.createAndVerify(null);
    }

    @Test
    public void createWithCustomThreshold() throws Exception {
        this.createAndVerify(this.defaultThreshold * 2);
    }

    @Test
    public void createDenseNodeWithLowThreshold() throws Exception {
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            Assert.assertEquals((long)2L, (long)node.getDegree());
            Assert.assertEquals((long)1L, (long)node.getDegree((RelationshipType)MyRelTypes.TEST));
            Assert.assertEquals((long)1L, (long)node.getDegree((RelationshipType)MyRelTypes.TEST2));
            tx.success();
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            Assert.assertEquals(NodeImpl.class, ((NodeManager)this.db.getDependencyResolver().resolveDependency(NodeManager.class)).getNodeForProxy(node.getId()).getClass());
            tx.success();
        }
        catch (Throwable x2) {
            var3_2 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.db.shutdown();
    }

    private void newDb(int denseNodeThreshold) {
        this.db = new ImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{"dense_node_threshold", "" + denseNodeThreshold})){

            @Override
            protected FileSystemAbstraction createFileSystemAbstraction() {
                return TestRelationshipGroupStore.this.fs = super.createFileSystemAbstraction();
            }
        };
    }

    private void createAndVerify(Integer customThreshold) {
        int expectedThreshold = customThreshold != null ? customThreshold : this.defaultThreshold;
        StoreFactory factory = this.factory(customThreshold);
        NeoStore neoStore = factory.createNeoStore(new File(this.neostoreFileName));
        Assert.assertEquals((long)expectedThreshold, (long)neoStore.getDenseNodeThreshold());
        neoStore.close();
        neoStore = factory.newNeoStore(new File(this.neostoreFileName));
        Assert.assertEquals((long)expectedThreshold, (long)neoStore.getDenseNodeThreshold());
        neoStore.close();
        factory = this.factory(999999);
        neoStore = factory.newNeoStore(new File(this.neostoreFileName));
        Assert.assertEquals((long)expectedThreshold, (long)neoStore.getDenseNodeThreshold());
        neoStore.close();
    }

    private StoreFactory factory(Integer customThreshold) {
        HashMap<String, String> customConfig = new HashMap<String, String>();
        if (customThreshold != null) {
            customConfig.put(GraphDatabaseSettings.dense_node_threshold.name(), "" + customThreshold);
        }
        return new StoreFactory(this.config(customConfig), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
    }

    private Config config(Map<String, String> customConfig) {
        return new Config(customConfig);
    }

    @Test
    public void makeSureRelationshipGroupsNextAndPrevGetsAssignedCorrectly() throws Exception {
        this.newDb(1);
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            Node node0 = this.db.createNode();
            Node node2 = this.db.createNode();
            node0.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            node.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            for (Relationship rel : node.getRelationships()) {
                rel.delete();
            }
            node.delete();
            tx.success();
        }
        this.db.shutdown();
    }

    @Test
    public void verifyRecordsForDenseNodeWithOneRelType() throws Exception {
        Relationship rel6;
        Relationship rel5;
        Relationship rel4;
        Relationship rel3;
        Relationship rel2;
        Relationship rel1;
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            rel1 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel2 = this.db.createNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel3 = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel4 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel5 = this.db.createNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel6 = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        NeoStore neoStore = ((XaDataSourceManager)this.db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().getNeoStore();
        NodeStore nodeStore = neoStore.getNodeStore();
        NodeRecord nodeRecord = nodeStore.getRecord(node.getId());
        long group = nodeRecord.getNextRel();
        RelationshipGroupStore groupStore = neoStore.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = groupStore.getRecord(group);
        Assert.assertEquals((long)-1L, (long)groupRecord.getNext());
        Assert.assertEquals((long)-1L, (long)groupRecord.getPrev());
        this.assertRelationshipChain(neoStore.getRelationshipStore(), node, groupRecord.getFirstOut(), rel1.getId(), rel4.getId());
        this.assertRelationshipChain(neoStore.getRelationshipStore(), node, groupRecord.getFirstIn(), rel2.getId(), rel5.getId());
        this.assertRelationshipChain(neoStore.getRelationshipStore(), node, groupRecord.getFirstLoop(), rel3.getId(), rel6.getId());
    }

    @Test
    public void verifyRecordsForDenseNodeWithTwoRelTypes() throws Exception {
        Relationship rel6;
        Relationship rel5;
        Relationship rel4;
        Relationship rel3;
        Relationship rel2;
        Relationship rel1;
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            rel1 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel2 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel3 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel4 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            rel5 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            rel6 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            tx.success();
        }
        NeoStore neoStore = ((XaDataSourceManager)this.db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().getNeoStore();
        NodeStore nodeStore = neoStore.getNodeStore();
        NodeRecord nodeRecord = nodeStore.getRecord(node.getId());
        long group = nodeRecord.getNextRel();
        RelationshipGroupStore groupStore = neoStore.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = groupStore.getRecord(group);
        Assert.assertFalse((groupRecord.getNext() == -1L ? 1 : 0) != 0);
        this.assertRelationshipChain(neoStore.getRelationshipStore(), node, groupRecord.getFirstOut(), rel1.getId(), rel2.getId(), rel3.getId());
        RelationshipGroupRecord otherGroupRecord = groupStore.getRecord(groupRecord.getNext());
        Assert.assertEquals((long)-1L, (long)otherGroupRecord.getNext());
        this.assertRelationshipChain(neoStore.getRelationshipStore(), node, otherGroupRecord.getFirstOut(), rel4.getId(), rel5.getId(), rel6.getId());
    }

    @Test
    public void verifyGroupIsDeletedWhenNeeded() throws Exception {
        this.newDb(2);
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Relationship rel1 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel2 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel3 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel4 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
        Relationship rel5 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
        Relationship rel6 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
        tx.success();
        tx.finish();
        NeoStore neoStore = ((XaDataSourceManager)this.db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().getNeoStore();
        NodeStore nodeStore = neoStore.getNodeStore();
        NodeRecord nodeRecord = nodeStore.getRecord(node.getId());
        long group = nodeRecord.getNextRel();
        RelationshipGroupStore groupStore = neoStore.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = groupStore.getRecord(group);
        Assert.assertFalse((groupRecord.getNext() == -1L ? 1 : 0) != 0);
        RelationshipGroupRecord otherGroupRecord = groupStore.getRecord(groupRecord.getNext());
        Assert.assertEquals((long)-1L, (long)otherGroupRecord.getNext());
    }

    private void assertRelationshipChain(RelationshipStore relationshipStore, Node node, long firstId, long ... chainedIds) {
        long nodeId = node.getId();
        RelationshipRecord record = relationshipStore.getRecord(firstId);
        HashSet<Long> readChain = new HashSet<Long>();
        readChain.add(firstId);
        while (true) {
            long nextId;
            long l = nextId = record.getFirstNode() == nodeId ? record.getFirstNextRel() : record.getSecondNextRel();
            if (nextId == -1L) break;
            readChain.add(nextId);
            record = relationshipStore.getRecord(nextId);
        }
        HashSet<Long> expectedChain = new HashSet<Long>(Arrays.asList(firstId));
        for (long id : chainedIds) {
            expectedChain.add(id);
        }
        Assert.assertEquals(expectedChain, readChain);
    }
}

