/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class TestStore {
    public static IdGeneratorFactory ID_GENERATOR_FACTORY = new DefaultIdGeneratorFactory();
    public static WindowPoolFactory WINDOW_POOL_FACTORY = new DefaultWindowPoolFactory();
    public static FileSystemAbstraction FILE_SYSTEM = new DefaultFileSystemAbstraction();

    private File path() {
        String path = AbstractNeo4jTestCase.getStorePath("teststore");
        File file = new File(path);
        file.mkdirs();
        return file;
    }

    private File file(String name) {
        return new File(this.path(), name);
    }

    private File storeFile() {
        return this.file("testStore.db");
    }

    private File storeIdFile() {
        return this.file("testStore.db.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStore() throws IOException {
        try {
            try {
                Store.createStore(null);
                Assert.fail((String)"Null fileName should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            Store store = Store.createStore(this.storeFile());
            try {
                Store.createStore(this.storeFile());
                Assert.fail((String)"Creating existing store should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private void deleteBothFiles() {
        File file = this.storeFile();
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = this.storeIdFile()).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyStore() throws IOException {
        try {
            Store.createStore(this.storeFile()).close();
            FileChannel fileChannel = new RandomAccessFile(this.storeFile(), "rw").getChannel();
            fileChannel.truncate(fileChannel.size() - 2L);
            fileChannel.close();
            Store store = new Store(this.storeFile());
            store.makeStoreOk();
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() throws IOException {
        try {
            Store store = Store.createStore(this.storeFile());
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private static class Store
    extends AbstractStore {
        public static final String TYPE_DESCRIPTOR = "TestVersion";
        private static final int RECORD_SIZE = 1;

        public Store(File fileName) throws IOException {
            super(fileName, new Config(MapUtil.stringMap((String[])new String[]{"store_dir", "target/var/teststore"}), new Class[]{GraphDatabaseSettings.class}), IdType.NODE, ID_GENERATOR_FACTORY, WINDOW_POOL_FACTORY, FILE_SYSTEM, StringLogger.DEV_NULL, StoreVersionMismatchHandler.THROW_EXCEPTION);
        }

        public int getRecordSize() {
            return 1;
        }

        public String getTypeDescriptor() {
            return TYPE_DESCRIPTOR;
        }

        public static Store createStore(File fileName) throws IOException {
            new StoreFactory(new Config(Collections.emptyMap(), new Class[]{GraphDatabaseSettings.class}), ID_GENERATOR_FACTORY, (WindowPoolFactory)new DefaultWindowPoolFactory(), FILE_SYSTEM, StringLogger.DEV_NULL, null).createEmptyStore(fileName, Store.buildTypeDescriptorAndVersion((String)TYPE_DESCRIPTOR));
            return new Store(fileName);
        }

        protected void rebuildIdGenerator() {
        }

        public List<WindowPoolStats> getAllWindowPoolStats() {
            return null;
        }
    }
}

