/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestStoreAccess {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final File storeDir = new File("dir");

    @Test
    public void openingThroughStoreAccessShouldNotTriggerRecovery() throws Exception {
        EphemeralFileSystemAbstraction snapshot = this.produceUncleanStore();
        Assert.assertTrue((String)"Store should be unclean", (boolean)this.isUnclean(snapshot));
        File messages = new File(this.storeDir, "messages.log");
        snapshot.deleteFile(messages);
        new StoreAccess((FileSystemAbstraction)snapshot, this.storeDir.getPath(), MapUtil.stringMap((String[])new String[0])).close();
        Assert.assertTrue((String)"Store should be unclean", (boolean)this.isUnclean(snapshot));
    }

    private EphemeralFileSystemAbstraction produceUncleanStore() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(this.storeDir.getPath());
        EphemeralFileSystemAbstraction snapshot = this.fs.get().snapshot();
        db.shutdown();
        return snapshot;
    }

    private boolean isUnclean(FileSystemAbstraction fileSystem) throws IOException {
        char chr = this.activeLog(fileSystem, this.storeDir);
        return chr == '1' || chr == '2';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char activeLog(FileSystemAbstraction fileSystem, File directory) throws IOException {
        try (StoreChannel file = fileSystem.open(new File(directory, "nioneo_logical.log.active"), "r");){
            ByteBuffer buffer = ByteBuffer.wrap(new byte[2]);
            file.read(buffer);
            buffer.flip();
            char c = buffer.getChar();
            return c;
        }
    }
}

