/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.scan.InMemoryLabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.PlaceboTm;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestXa {
    private final EphemeralFileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    private NeoStoreXaDataSource ds;
    private File logBaseFileName;
    private NeoStoreXaConnection xaCon;
    private Logger log;
    private Level level;
    private Map<String, Token> propertyKeyTokens;
    private static final NeoStoreTransaction.PropertyReceiver VOID = new NeoStoreTransaction.PropertyReceiver(){

        public void receive(DefinedProperty property, long propertyRecordId) {
        }
    };

    private File path() {
        String path = "xatest";
        File file = new File(path);
        this.fileSystem.mkdirs(file);
        return file;
    }

    private File file(String name) {
        return new File(this.path(), name);
    }

    @Before
    public void setUpNeoStore() throws Exception {
        this.log = Logger.getLogger("org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog/nioneo_logical.log");
        this.level = this.log.getLevel();
        this.log.setLevel(Level.OFF);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource");
        this.log.setLevel(Level.OFF);
        this.propertyKeyTokens = new HashMap<String, Token>();
        StoreFactory sf = new StoreFactory(new Config(Collections.emptyMap(), new Class[]{GraphDatabaseSettings.class}), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fileSystem, StringLogger.DEV_NULL, null);
        sf.createNeoStore(this.file("neo")).close();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        this.logBaseFileName = this.ds.getXaContainer().getLogicalLog().getBaseFileName();
    }

    @After
    public void tearDownNeoStore() {
        this.ds.stop();
        this.log.setLevel(this.level);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog/nioneo_logical.log");
        this.log.setLevel(this.level);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource");
        this.log.setLevel(this.level);
        for (String file : new String[]{"neo", "neo.nodestore.db", "neo.nodestore.db.labels", "neo.propertystore.db", "neo.propertystore.db.index", "neo.propertystore.db.index.keys", "neo.propertystore.db.strings", "neo.propertystore.db.arrays", "neo.relationshipstore.db", "neo.relationshiptypestore.db", "neo.relationshiptypestore.db.names", "neo.schemastore.db"}) {
            this.fileSystem.deleteFile(this.file(file));
            this.fileSystem.deleteFile(this.file(file + ".id"));
        }
        File file = new File(".");
        for (File nioFile : this.fileSystem.listFiles(file)) {
            if (!nioFile.getName().startsWith("nioneo_logical.log")) continue;
            Assert.assertTrue((String)("Couldn't delete '" + nioFile.getPath() + "'"), (boolean)this.fileSystem.deleteFile(nioFile));
        }
    }

    private void deleteLogicalLogIfExist() {
        File file = new File(this.logBaseFileName.getPath() + ".1");
        if (this.fileSystem.fileExists(file)) {
            Assert.assertTrue((boolean)this.fileSystem.deleteFile(file));
        }
        if (this.fileSystem.fileExists(file = new File(this.logBaseFileName.getPath() + ".2"))) {
            Assert.assertTrue((boolean)this.fileSystem.deleteFile(file));
        }
        file = new File(this.logBaseFileName.getPath() + ".active");
        Assert.assertTrue((boolean)this.fileSystem.deleteFile(file));
        for (int i = 5; i >= 0 && !this.fileSystem.deleteFile(new File(this.logBaseFileName.getPath() + ".v" + i)); --i) {
        }
    }

    public static void renameCopiedLogicalLog(FileSystemAbstraction fileSystem, Pair<Pair<File, File>, Pair<File, File>> files) throws IOException {
        fileSystem.deleteFile((File)((Pair)files.first()).first());
        fileSystem.renameFile((File)((Pair)files.first()).other(), (File)((Pair)files.first()).first());
        fileSystem.deleteFile((File)((Pair)files.other()).first());
        fileSystem.renameFile((File)((Pair)files.other()).other(), (File)((Pair)files.other()).first());
    }

    private void truncateLogicalLog(int size) throws IOException {
        StoreChannel af = this.fileSystem.open(new File(this.logBaseFileName.getPath() + ".active"), "r");
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        af.read(buffer);
        af.close();
        buffer.flip();
        char active = buffer.asCharBuffer().get();
        buffer.clear();
        StoreChannel fileChannel = this.fileSystem.open(new File(this.logBaseFileName.getPath() + "." + active), "rw");
        if (fileChannel.size() > (long)size) {
            fileChannel.truncate((long)size);
        } else {
            fileChannel.position((long)size);
            ByteBuffer buf = ByteBuffer.allocate(1);
            buf.put((byte)0).flip();
            fileChannel.write(buf);
        }
        fileChannel.force(false);
        fileChannel.close();
    }

    public static Pair<Pair<File, File>, Pair<File, File>> copyLogicalLog(FileSystemAbstraction fileSystem, File logBaseFileName) throws IOException {
        int read;
        File activeLog = new File(logBaseFileName.getPath() + ".active");
        StoreChannel af = fileSystem.open(activeLog, "r");
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        af.read(buffer);
        buffer.flip();
        File activeLogBackup = new File(logBaseFileName.getPath() + ".bak.active");
        StoreChannel activeCopy = fileSystem.open(activeLogBackup, "rw");
        activeCopy.write(buffer);
        activeCopy.close();
        af.close();
        buffer.flip();
        char active = buffer.asCharBuffer().get();
        buffer.clear();
        File currentLog = new File(logBaseFileName.getPath() + "." + active);
        StoreChannel source = fileSystem.open(currentLog, "r");
        File currentLogBackup = new File(logBaseFileName.getPath() + ".bak." + active);
        StoreChannel dest = fileSystem.open(currentLogBackup, "rw");
        do {
            read = source.read(buffer);
            buffer.flip();
            dest.write(buffer);
            buffer.clear();
        } while (read == 1024);
        source.close();
        dest.close();
        return Pair.of((Object)Pair.of((Object)activeLog, (Object)activeLogBackup), (Object)Pair.of((Object)currentLog, (Object)currentLogBackup));
    }

    private int index(String key) {
        Token result = this.propertyKeyTokens.get(key);
        if (result != null) {
            return result.id();
        }
        int id = (int)this.ds.nextId(PropertyKeyTokenRecord.class);
        Token index = new Token(key, id);
        this.propertyKeyTokens.put(key, index);
        this.xaCon.getTransaction().createPropertyKeyToken(key, id);
        return id;
    }

    @Test
    public void testLogicalLog() throws Exception {
        XidImpl xid = new XidImpl(new byte[1], new byte[1]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node2);
        DefinedProperty n1prop1 = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        this.xaCon.getTransaction().nodeLoadProperties(node1, false, VOID);
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getTransaction().createRelationshipTypeToken(relType1, "relationshiptype1");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel1, relType1, node1, node2);
        DefinedProperty r1prop1 = this.xaCon.getTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        n1prop1 = this.xaCon.getTransaction().nodeChangeProperty(node1, n1prop1.propertyKeyId(), (Object)"string2");
        r1prop1 = this.xaCon.getTransaction().relChangeProperty(rel1, r1prop1.propertyKeyId(), (Object)"string2");
        this.xaCon.getTransaction().nodeRemoveProperty(node1, n1prop1.propertyKeyId());
        this.xaCon.getTransaction().relRemoveProperty(rel1, r1prop1.propertyKeyId());
        this.xaCon.getTransaction().relDelete(rel1);
        this.xaCon.getTransaction().nodeDelete(node1);
        this.xaCon.getTransaction().nodeDelete(node2);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        Pair<Pair<File, File>, Pair<File, File>> copies = TestXa.copyLogicalLog(this.fileSystem, this.logBaseFileName);
        this.xaCon.clearAllTransactions();
        this.ds.stop();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.fileSystem, copies);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    private NeoStoreXaDataSource newNeoStore() throws IOException {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{InternalAbstractGraphDatabase.Configuration.store_dir.name(), this.path().getPath(), InternalAbstractGraphDatabase.Configuration.neo_store.name(), this.file("neo").getPath(), InternalAbstractGraphDatabase.Configuration.logical_log.name(), this.file("nioneo_logical.log").getPath()}), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fileSystem, StringLogger.DEV_NULL, null);
        PlaceboTm txManager = new PlaceboTm(null, TxIdGenerator.DEFAULT);
        for (File file : this.fileSystem.listFiles(this.path())) {
            if (!file.isFile() || !file.getName().startsWith("nioneo_logical.log.v")) continue;
            this.fileSystem.deleteFile(file);
        }
        NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        List<Cache> caches = Arrays.asList((Cache)Mockito.mock(AutoLoadingCache.class), (Cache)Mockito.mock(AutoLoadingCache.class));
        Mockito.when((Object)nodeManager.caches()).thenReturn(caches);
        KernelHealth kernelHealth = (KernelHealth)Mockito.mock(KernelHealth.class);
        NeoStoreXaDataSource neoStoreXaDataSource = new NeoStoreXaDataSource(config, (LockService)new ReentrantLockService(), sf, StringLogger.DEV_NULL, new XaFactory(config, TxIdGenerator.DEFAULT, (AbstractTransactionManager)txManager, (FileSystemAbstraction)this.fileSystem, new Monitors(), (Logging)new DevNullLoggingService(), RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING, kernelHealth), TransactionStateFactory.noStateFactory((Logging)new DevNullLoggingService()), new TransactionInterceptorProviders(Collections.emptyList(), (DependencyResolver)this.dependencyResolverForConfig(config)), null, (Logging)new SingleLoggingService(StringLogger.DEV_NULL), (UpdateableSchemaState)new KernelSchemaStateStore(), (TokenNameLookup)Mockito.mock(TokenNameLookup.class), this.dependencyResolverForNoIndexProvider(nodeManager), (AbstractTransactionManager)txManager, (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class), (LabelTokenHolder)Mockito.mock(LabelTokenHolder.class), (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class), (PersistenceManager)Mockito.mock(PersistenceManager.class), (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), (TransactionEventHandlers)Mockito.mock(TransactionEventHandlers.class), IndexingService.NO_MONITOR, (FileSystemAbstraction)this.fileSystem, (Function)new Function<NeoStore, Function<List<LogEntry>, List<LogEntry>>>(){

            public Function<List<LogEntry>, List<LogEntry>> apply(NeoStore neoStore) {
                return Functions.identity();
            }
        }, (StoreUpgrader)Mockito.mock(StoreUpgrader.class));
        neoStoreXaDataSource.init();
        neoStoreXaDataSource.start();
        return neoStoreXaDataSource;
    }

    private DependencyResolver dependencyResolverForNoIndexProvider(final NodeManager nodeManager) {
        return new DependencyResolver.Adapter(){
            private final LabelScanStoreProvider labelScanStoreProvider = new LabelScanStoreProvider((LabelScanStore)new InMemoryLabelScanStore(), 10);

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (SchemaIndexProvider.class.isAssignableFrom(type)) {
                    return type.cast(SchemaIndexProvider.NO_INDEX_PROVIDER);
                }
                if (NodeManager.class.isAssignableFrom(type)) {
                    return type.cast(nodeManager);
                }
                if (LabelScanStoreProvider.class.isAssignableFrom(type)) {
                    return type.cast(this.labelScanStoreProvider);
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }

    private DependencyResolver.Adapter dependencyResolverForConfig(final Config config) {
        return new DependencyResolver.Adapter(){

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
                return type.cast(config);
            }
        };
    }

    @Test
    public void testLogicalLogPrepared() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node2);
        DefinedProperty n1prop1 = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getTransaction().createRelationshipTypeToken(relType1, "relationshiptype1");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel1, relType1, node1, node2);
        DefinedProperty r1prop1 = this.xaCon.getTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        this.xaCon.getTransaction().nodeChangeProperty(node1, n1prop1.propertyKeyId(), (Object)"string2");
        this.xaCon.getTransaction().relChangeProperty(rel1, r1prop1.propertyKeyId(), (Object)"string2");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        Pair<Pair<File, File>, Pair<File, File>> copies = TestXa.copyLogicalLog(this.fileSystem, this.logBaseFileName);
        this.xaCon.clearAllTransactions();
        this.ds.stop();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.fileSystem, copies);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testLogicalLogPreparedPropertyBlocks() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        DefinedProperty n1prop1 = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
        this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop2"), (Object)new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        this.copyClearRename();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
        xid = new XidImpl(new byte[2], new byte[2]);
        xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        this.xaCon.getTransaction().nodeRemoveProperty(node1, n1prop1.propertyKeyId());
        this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop3"), (Object)new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        this.copyClearRename();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
    }

    private void copyClearRename() throws IOException {
        this.copyClearRename(true);
    }

    private void copyClearRename(boolean clearTransactions) throws IOException {
        Pair<Pair<File, File>, Pair<File, File>> copies = TestXa.copyLogicalLog(this.fileSystem, this.logBaseFileName);
        if (clearTransactions) {
            this.xaCon.clearAllTransactions();
        }
        this.ds.stop();
        this.deleteLogicalLogIfExist();
        TestXa.renameCopiedLogicalLog(this.fileSystem, copies);
    }

    @Test
    public void makeSureRecordsAreCreated() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)new long[]{Long.MIN_VALUE, 1L, 1L});
        this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop2"), (Object)new long[]{Long.MIN_VALUE, 1L, 1L});
        DefinedProperty toRead = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop3"), (Object)new long[]{Long.MIN_VALUE, 1L, 1L});
        DefinedProperty toDelete = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop4"), (Object)new long[]{Long.MIN_VALUE, 1L, 1L});
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        this.ds.rotateLogicalLog();
        this.copyClearRename();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        xid = new XidImpl(new byte[2], new byte[2]);
        xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        this.xaCon.getTransaction().nodeRemoveProperty(node1, toDelete.propertyKeyId());
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        this.ds.rotateLogicalLog();
        this.copyClearRename();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        xid = new XidImpl(new byte[2], new byte[2]);
        xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        Assert.assertTrue((boolean)Arrays.equals((long[])toRead.value(), (long[])this.loadNodeProperty(this.xaCon.getTransaction(), node1, toRead.propertyKeyId())));
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.xaCon.clearAllTransactions();
        this.ds.stop();
        this.deleteLogicalLogIfExist();
    }

    private Object loadNodeProperty(NeoStoreTransaction writeTransaction, long node, final long propertyKeyId) {
        final AtomicReference foundProperty = new AtomicReference();
        NeoStoreTransaction.PropertyReceiver receiver = new NeoStoreTransaction.PropertyReceiver(){

            public void receive(DefinedProperty property, long propertyRecordId) {
                if (propertyKeyId == (long)property.propertyKeyId()) {
                    DefinedProperty previous = foundProperty.getAndSet(property);
                    Assert.assertNull((Object)previous);
                }
            }
        };
        writeTransaction.nodeLoadProperties(node, false, receiver);
        Assert.assertNotNull(foundProperty.get());
        return ((DefinedProperty)foundProperty.get()).value();
    }

    @Test
    public void testDynamicRecordsInLog() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        DefinedProperty toChange = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"hi");
        DefinedProperty toRead = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop2"), (Object)new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        this.copyClearRename();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
        xid = new XidImpl(new byte[2], new byte[2]);
        xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        this.xaCon.getTransaction().nodeChangeProperty(node1, toChange.propertyKeyId(), (Object)"hI");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.ds.rotateLogicalLog();
        this.copyClearRename();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
        Assert.assertTrue((boolean)Arrays.equals(new long[]{0x800000L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L}, (long[])this.loadNodeProperty(this.xaCon.getTransaction(), node1, toRead.propertyKeyId())));
    }

    @Test
    public void testLogicalLogPrePrepared() throws Exception {
        XidImpl xid = new XidImpl(new byte[3], new byte[3]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node2);
        DefinedProperty n1prop1 = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getTransaction().createRelationshipTypeToken(relType1, "relationshiptype1");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel1, relType1, node1, node2);
        DefinedProperty r1prop1 = this.xaCon.getTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        this.xaCon.getTransaction().nodeChangeProperty(node1, n1prop1.propertyKeyId(), (Object)"string2");
        this.xaCon.getTransaction().relChangeProperty(rel1, r1prop1.propertyKeyId(), (Object)"string2");
        xaRes.end((Xid)xid, 0x4000000);
        this.copyClearRename();
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
    }

    @Test
    public void testBrokenNodeCommand() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.xaCon.clearAllTransactions();
        this.copyClearRename();
        this.truncateLogicalLog(102);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenCommand() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.copyClearRename();
        this.truncateLogicalLog(102);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenPrepare() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node2);
        this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string value 1");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.copyClearRename();
        this.truncateLogicalLog(243);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenDone() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node2);
        this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string value 1");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.commit((Xid)xid, false);
        this.copyClearRename(false);
        this.truncateLogicalLog(318);
        this.ds = this.newNeoStore();
        this.xaCon = this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testLogVersion() {
        long creationTime = this.ds.getCreationTime();
        long randomIdentifier = this.ds.getRandomIdentifier();
        long currentVersion = this.ds.getCurrentLogVersion();
        Assert.assertEquals((long)currentVersion, (long)this.ds.incrementAndGetLogVersion());
        Assert.assertEquals((long)(currentVersion + 1L), (long)this.ds.incrementAndGetLogVersion());
        Assert.assertEquals((long)creationTime, (long)this.ds.getCreationTime());
        Assert.assertEquals((long)randomIdentifier, (long)this.ds.getRandomIdentifier());
    }

    @Test
    public void testLogicalLogRotation() throws Exception {
        XidImpl xid = new XidImpl(new byte[1], new byte[1]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        long node1 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node1);
        long node2 = this.ds.nextId(Node.class);
        this.xaCon.getTransaction().nodeCreate(node2);
        DefinedProperty n1prop1 = this.xaCon.getTransaction().nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        this.xaCon.getTransaction().nodeLoadProperties(node1, false, VOID);
        int relType1 = (int)this.ds.nextId(RelationshipType.class);
        this.xaCon.getTransaction().createRelationshipTypeToken(relType1, "relationshiptype1");
        long rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getTransaction().relationshipCreate(rel1, relType1, node1, node2);
        DefinedProperty r1prop1 = this.xaCon.getTransaction().relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        n1prop1 = this.xaCon.getTransaction().nodeChangeProperty(node1, n1prop1.propertyKeyId(), (Object)"string2");
        r1prop1 = this.xaCon.getTransaction().relChangeProperty(rel1, r1prop1.propertyKeyId(), (Object)"string2");
        this.xaCon.getTransaction().nodeRemoveProperty(node1, n1prop1.propertyKeyId());
        this.xaCon.getTransaction().relRemoveProperty(rel1, r1prop1.propertyKeyId());
        this.xaCon.getTransaction().relDelete(rel1);
        this.xaCon.getTransaction().nodeDelete(node1);
        this.xaCon.getTransaction().nodeDelete(node2);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        long currentVersion = this.ds.getCurrentLogVersion();
        this.ds.rotateLogicalLog();
        Assert.assertTrue((boolean)this.logicalLogExists(currentVersion));
        this.ds.rotateLogicalLog();
        Assert.assertTrue((boolean)this.logicalLogExists(currentVersion));
        Assert.assertTrue((boolean)this.logicalLogExists(currentVersion + 1L));
    }

    private boolean logicalLogExists(long version) throws IOException {
        ReadableByteChannel log = this.ds.getLogicalLog(version);
        if (log != null) {
            log.close();
            return true;
        }
        return false;
    }
}

