/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import javax.transaction.xa.XAException;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.xa.IntegrityValidator;
import org.powermock.api.mockito.PowerMockito;

public class IntegrityValidatorTest {
    @Test
    public void shouldValidateUniquenessIndexes() throws Exception {
        NeoStore store = (NeoStore)PowerMockito.mock(NeoStore.class);
        IndexingService indexes = (IndexingService)PowerMockito.mock(IndexingService.class);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        ((IndexingService)Mockito.doThrow((Throwable)new ConstraintVerificationFailedKernelException(null, (Throwable)new RuntimeException())).when((Object)indexes)).validateIndex(2L);
        UniquenessConstraintRule record = UniquenessConstraintRule.uniquenessConstraintRule((long)1L, (int)1, (int)1, (long)2L);
        try {
            validator.validateSchemaRule((SchemaRule)record);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (XAException e) {
            MatcherAssert.assertThat((Object)e.errorCode, (Matcher)Matchers.equalTo((Object)103));
        }
    }

    @Test
    public void deletingNodeWithRelationshipsIsNotAllowed() throws Exception {
        NeoStore store = (NeoStore)PowerMockito.mock(NeoStore.class);
        IndexingService indexes = (IndexingService)PowerMockito.mock(IndexingService.class);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        NodeRecord record = new NodeRecord(1L, false, 1L, -1L);
        record.setInUse(false);
        try {
            validator.validateNodeRecord(record);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (XAException e) {
            MatcherAssert.assertThat((Object)e.errorCode, (Matcher)Matchers.equalTo((Object)103));
        }
    }

    @Test
    public void transactionsStartedBeforeAConstraintWasCreatedAreDisallowed() throws Exception {
        NeoStore store = (NeoStore)PowerMockito.mock(NeoStore.class);
        IndexingService indexes = (IndexingService)PowerMockito.mock(IndexingService.class);
        Mockito.when((Object)store.getLatestConstraintIntroducingTx()).thenReturn((Object)10L);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        try {
            validator.validateTransactionStartKnowledge(1L);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (XAException e) {
            MatcherAssert.assertThat((Object)e.errorCode, (Matcher)Matchers.equalTo((Object)103));
        }
    }
}

