/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandReaderV1;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class LogTruncationTest {
    private final InMemoryLogBuffer inMemoryBuffer = new InMemoryLogBuffer();
    private final PhysicalLogNeoXaCommandReaderV1 reader = new PhysicalLogNeoXaCommandReaderV1(ByteBuffer.allocate(100));
    private final PhysicalLogNeoXaCommandWriter writer = new PhysicalLogNeoXaCommandWriter();
    private final Map<Class<?>, XaCommand[]> permutations = new HashMap();

    public LogTruncationTest() {
        this.permutations.put(Command.NeoStoreCommand.class, new XaCommand[]{new Command.NeoStoreCommand().init(new NeoStoreRecord())});
        this.permutations.put(Command.NodeCommand.class, new XaCommand[]{new Command.NodeCommand().init(new NodeRecord(12L, false, 13L, 13L), new NodeRecord(0L, false, 0L, 0L))});
        this.permutations.put(Command.RelationshipCommand.class, new XaCommand[]{new Command.RelationshipCommand().init(new RelationshipRecord(1L, 2L, 3L, 4))});
        this.permutations.put(Command.PropertyCommand.class, new XaCommand[]{new Command.PropertyCommand().init(new PropertyRecord(1L, (PrimitiveRecord)new NodeRecord(12L, false, 13L, 13L)), new PropertyRecord(1L, (PrimitiveRecord)new NodeRecord(12L, false, 13L, 13L)))});
        this.permutations.put(Command.RelationshipGroupCommand.class, new XaCommand[]{new Command.LabelTokenCommand().init(new LabelTokenRecord(1))});
        this.permutations.put(Command.SchemaRuleCommand.class, new XaCommand[]{new Command.SchemaRuleCommand().init(Arrays.asList(DynamicRecord.dynamicRecord((long)1L, (boolean)false, (boolean)true, (long)-1L, (int)1, (byte[])"hello".getBytes())), Arrays.asList(DynamicRecord.dynamicRecord((long)1L, (boolean)true, (boolean)true, (long)-1L, (int)1, (byte[])"hello".getBytes())), (SchemaRule)new IndexRule(1L, 2, 3, new SchemaIndexProvider.Descriptor("myIdx", "12"), Long.valueOf(12L)), 1L)});
        this.permutations.put(Command.RelationshipTypeTokenCommand.class, new XaCommand[]{new Command.RelationshipTypeTokenCommand().init(new RelationshipTypeTokenRecord(1))});
        this.permutations.put(Command.PropertyKeyTokenCommand.class, new XaCommand[]{new Command.PropertyKeyTokenCommand().init(new PropertyKeyTokenRecord(1))});
        this.permutations.put(Command.LabelTokenCommand.class, new XaCommand[]{new Command.LabelTokenCommand().init(new LabelTokenRecord(1))});
    }

    @Test
    public void testSerializationInFaceOfLogTruncation() throws Exception {
        for (XaCommand cmd : this.enumerateCommands()) {
            this.assertHandlesLogTruncation(cmd);
        }
    }

    private Iterable<XaCommand> enumerateCommands() {
        ArrayList<XaCommand> commands = new ArrayList<XaCommand>();
        for (Class<?> cmd : Command.class.getClasses()) {
            if (!XaCommand.class.isAssignableFrom(cmd)) continue;
            if (this.permutations.containsKey(cmd)) {
                commands.addAll(Arrays.asList((Object[])this.permutations.get(cmd)));
                continue;
            }
            throw new AssertionError((Object)("Unknown command type: " + cmd + ", please add missing instantiation to " + "test serialization of this command."));
        }
        return commands;
    }

    private void assertHandlesLogTruncation(XaCommand cmd) throws IOException {
        this.inMemoryBuffer.reset();
        this.writer.write(cmd, (LogBuffer)this.inMemoryBuffer);
        int bytesSuccessfullyWritten = this.inMemoryBuffer.bytesWritten();
        try {
            Assert.assertEquals((Object)cmd, (Object)this.reader.read((ReadableByteChannel)this.inMemoryBuffer));
        }
        catch (Exception e) {
            throw new AssertionError("Failed to deserialize " + cmd.toString() + ", because: ", e);
        }
        while (true) {
            int n = --bytesSuccessfullyWritten;
            --bytesSuccessfullyWritten;
            if (n <= 0) break;
            this.inMemoryBuffer.reset();
            this.writer.write(cmd, (LogBuffer)this.inMemoryBuffer);
            this.inMemoryBuffer.truncateTo(bytesSuccessfullyWritten);
            XaCommand deserialized = this.reader.read((ReadableByteChannel)this.inMemoryBuffer);
            TestCase.assertNull((String)("Deserialization did not detect log truncation! Record: " + cmd + ", deserialized: " + deserialized), (Object)deserialized);
        }
    }

    public class InMemoryLogBuffer
    implements LogBuffer,
    ReadableByteChannel {
        private byte[] bytes = new byte[1000];
        private int writeIndex;
        private int readIndex;
        private ByteBuffer bufferForConversions = ByteBuffer.wrap(new byte[100]);

        public void reset() {
            this.readIndex = 0;
            this.writeIndex = 0;
        }

        public void truncateTo(int bytes) {
            this.writeIndex = bytes;
        }

        public int bytesWritten() {
            return this.writeIndex;
        }

        private void ensureArrayCapacityPlus(int plus) {
            while (this.writeIndex + plus > this.bytes.length) {
                byte[] tmp = this.bytes;
                this.bytes = new byte[this.bytes.length * 2];
                System.arraycopy(tmp, 0, this.bytes, 0, tmp.length);
            }
        }

        private LogBuffer flipAndPut() {
            this.ensureArrayCapacityPlus(this.bufferForConversions.limit());
            System.arraycopy(this.bufferForConversions.flip().array(), 0, this.bytes, this.writeIndex, this.bufferForConversions.limit());
            this.writeIndex += this.bufferForConversions.limit();
            return this;
        }

        public LogBuffer put(byte b) throws IOException {
            this.ensureArrayCapacityPlus(1);
            this.bytes[this.writeIndex++] = b;
            return this;
        }

        public LogBuffer putShort(short s) throws IOException {
            ((ByteBuffer)this.bufferForConversions.clear()).putShort(s);
            return this.flipAndPut();
        }

        public LogBuffer putInt(int i) throws IOException {
            ((ByteBuffer)this.bufferForConversions.clear()).putInt(i);
            return this.flipAndPut();
        }

        public LogBuffer putLong(long l) throws IOException {
            ((ByteBuffer)this.bufferForConversions.clear()).putLong(l);
            return this.flipAndPut();
        }

        public LogBuffer putFloat(float f) throws IOException {
            ((ByteBuffer)this.bufferForConversions.clear()).putFloat(f);
            return this.flipAndPut();
        }

        public LogBuffer putDouble(double d) throws IOException {
            ((ByteBuffer)this.bufferForConversions.clear()).putDouble(d);
            return this.flipAndPut();
        }

        public LogBuffer put(byte[] bytes) throws IOException {
            this.ensureArrayCapacityPlus(bytes.length);
            System.arraycopy(bytes, 0, this.bytes, this.writeIndex, bytes.length);
            this.writeIndex += bytes.length;
            return this;
        }

        public LogBuffer put(char[] chars) throws IOException {
            this.ensureConversionBufferCapacity(chars.length * 2);
            this.bufferForConversions.clear();
            for (char ch : chars) {
                this.bufferForConversions.putChar(ch);
            }
            return this.flipAndPut();
        }

        private void ensureConversionBufferCapacity(int length) {
            if (this.bufferForConversions.capacity() < length) {
                this.bufferForConversions = ByteBuffer.wrap(new byte[length * 2]);
            }
        }

        public void writeOut() throws IOException {
        }

        public void force() throws IOException {
        }

        public long getFileChannelPosition() throws IOException {
            return this.readIndex;
        }

        public StoreChannel getFileChannel() {
            throw new UnsupportedOperationException();
        }

        public ReadableByteChannel getReadableChannel() {
            return this;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.readIndex >= this.writeIndex) {
                return -1;
            }
            int actualLengthToRead = Math.min(dst.limit(), this.writeIndex - this.readIndex);
            try {
                dst.put(this.bytes, this.readIndex, actualLengthToRead);
                int n = actualLengthToRead;
                return n;
            }
            finally {
                this.readIndex += actualLengthToRead;
            }
        }
    }
}

