/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreMocking;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;

public class NeoStoreTransactionContextTest {
    @Test
    public void shouldClearRecordSetsOnClose() throws Exception {
        NeoStore mockStore = NeoStoreMocking.mockNeoStore();
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(mockStore);
        NeoStoreTransactionContext toClose = new NeoStoreTransactionContext(supplier, mockStore);
        toClose.getNodeCommands().put(1L, Mockito.mock(Command.NodeCommand.class));
        toClose.setNeoStoreCommand((Command.NeoStoreCommand)Mockito.mock(Command.NeoStoreCommand.class));
        toClose.close();
        Assert.assertTrue((boolean)toClose.getNodeCommands().isEmpty());
        Assert.assertNull((Object)toClose.getNeoStoreCommand().getRecord());
    }

    @Test
    public void shouldClearBindingsOnClose() throws Exception {
        NeoStore mockStore = NeoStoreMocking.mockNeoStore();
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(mockStore);
        NeoStoreTransactionContext toClose = new NeoStoreTransactionContext(supplier, mockStore);
        toClose.bind((TransactionState)Mockito.mock(TransactionState.class));
        toClose.close();
        Assert.assertNull((Object)toClose.getTransactionState());
    }

    @Test
    public void shouldCallReleaseOnClose() throws Exception {
        NeoStore mockStore = NeoStoreMocking.mockNeoStore();
        NeoStoreTransactionContextSupplier supplier = (NeoStoreTransactionContextSupplier)Mockito.spy((Object)new NeoStoreTransactionContextSupplier(mockStore));
        NeoStoreTransactionContext toClose = new NeoStoreTransactionContext(supplier, mockStore);
        toClose.close();
        ((NeoStoreTransactionContextSupplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)1))).release((Object)toClose);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{supplier});
    }
}

