/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.direct.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdates;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.xa.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.nioneo.xa.IntegrityValidator;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class NeoStoreTransactionTest {
    public static final String LONG_STRING = "string value long enough not to be stored as a short string";
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TransactionState transactionState = (TransactionState)Mockito.mock(TransactionState.class);
    private Config config;
    private final DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
    private final DefaultWindowPoolFactory windowPoolFactory = new DefaultWindowPoolFactory();
    private NeoStore neoStore;
    private LockService locks;
    private CacheAccessBackDoor cacheAccessBackDoor;
    private final List<Lock> lockMocks = new ArrayList<Lock>();
    private final IndexingService mockIndexing = (IndexingService)Mockito.mock(IndexingService.class);
    private final KernelTransactionImplementation kernelTransaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
    private static final long[] none = new long[0];
    private static final Visitor<XaCommand, RuntimeException> nullVisitor = new Visitor<XaCommand, RuntimeException>(){

        public boolean visit(XaCommand element) {
            return true;
        }
    };
    public static final LabelScanStore NO_LABEL_SCAN_STORE = new LabelScanStore(){

        public LabelScanReader newReader() {
            return LabelScanReader.EMPTY;
        }

        public LabelScanWriter newWriter() {
            return LabelScanWriter.EMPTY;
        }

        public void stop() {
        }

        public void start() {
        }

        public void shutdown() {
        }

        public void recover(Iterator<NodeLabelUpdate> updates) {
        }

        public AllEntriesLabelScanReader newAllEntriesReader() {
            return null;
        }

        public ResourceIterator<File> snapshotStoreFiles() {
            return IteratorUtil.emptyIterator();
        }

        public void init() {
        }

        public void force() {
        }
    };

    @Test
    public void shouldValidateConstraintIndexAsPartOfPrepare() throws Exception {
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        long indexId = this.neoStore.getSchemaStore().nextId();
        long constraintId = this.neoStore.getSchemaStore().nextId();
        writeTransaction.createSchemaRule((SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)constraintId, (int)1, (int)1, (long)indexId));
        writeTransaction.prepare();
        ((IndexingService)Mockito.verify((Object)this.mockIndexing)).validateIndex(indexId);
    }

    @Test
    public void shouldAddSchemaRuleToCacheWhenApplyingTransactionThatCreatesOne() throws Exception {
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        long ruleId = this.neoStore.getSchemaStore().nextId();
        IndexRule schemaRule = IndexRule.indexRule((long)ruleId, (int)10, (int)8, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        writeTransaction.createSchemaRule((SchemaRule)schemaRule);
        this.prepareAndCommit(writeTransaction);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccessBackDoor)).addSchemaRule((SchemaRule)schemaRule);
    }

    @Test
    public void shouldRemoveSchemaRuleFromCacheWhenApplyingTransactionThatDeletesOne() throws Exception {
        SchemaStore schemaStore = this.neoStore.getSchemaStore();
        int labelId = 10;
        int propertyKey = 10;
        IndexRule rule = IndexRule.indexRule((long)schemaStore.nextId(), (int)labelId, (int)propertyKey, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Collection records = schemaStore.allocateFrom((SchemaRule)rule);
        for (DynamicRecord record : records) {
            schemaStore.updateRecord(record);
        }
        long ruleId = ((DynamicRecord)IteratorUtil.first((Iterable)records)).getId();
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        writeTransaction.dropSchemaRule((SchemaRule)rule);
        this.prepareAndCommit(writeTransaction);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccessBackDoor)).removeSchemaRuleFromCache(ruleId);
    }

    @Test
    public void shouldMarkDynamicLabelRecordsAsNotInUseWhenLabelsAreReInlined() throws Exception {
        long nodeId = this.neoStore.getNodeStore().nextId();
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.addLabelToNode(7, nodeId);
        writeTransaction.addLabelToNode(11, nodeId);
        writeTransaction.addLabelToNode(12, nodeId);
        writeTransaction.addLabelToNode(15, nodeId);
        writeTransaction.addLabelToNode(23, nodeId);
        writeTransaction.addLabelToNode(27, nodeId);
        writeTransaction.addLabelToNode(50, nodeId);
        this.prepareAndCommit(writeTransaction);
        CommandCapturingVisitor commandCapture = new CommandCapturingVisitor();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing, commandCapture).first();
        writeTransaction.removeLabelFromNode(11, nodeId);
        writeTransaction.removeLabelFromNode(23, nodeId);
        this.prepareAndCommit(writeTransaction);
        commandCapture.visitCapturedCommands(new Visitor<XaCommand, RuntimeException>(){

            public boolean visit(XaCommand element) throws RuntimeException {
                if (element instanceof Command.NodeCommand) {
                    Command.NodeCommand cmd = (Command.NodeCommand)element;
                    Collection beforeDynLabels = cmd.getAfter().getDynamicLabelRecords();
                    Assert.assertThat((Object)beforeDynLabels.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
                    Assert.assertThat((Object)((DynamicRecord)beforeDynLabels.iterator().next()).inUse(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
                }
                return true;
            }
        });
    }

    @Test
    public void shouldReUseOriginalDynamicRecordWhenInlinedAndThenExpandedLabelsInSameTx() throws Exception {
        long nodeId = this.neoStore.getNodeStore().nextId();
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.addLabelToNode(16, nodeId);
        writeTransaction.addLabelToNode(29, nodeId);
        writeTransaction.addLabelToNode(32, nodeId);
        writeTransaction.addLabelToNode(41, nodeId);
        writeTransaction.addLabelToNode(44, nodeId);
        writeTransaction.addLabelToNode(45, nodeId);
        writeTransaction.addLabelToNode(50, nodeId);
        writeTransaction.addLabelToNode(51, nodeId);
        writeTransaction.addLabelToNode(52, nodeId);
        this.prepareAndCommit(writeTransaction);
        CommandCapturingVisitor commandCapture = new CommandCapturingVisitor();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing, commandCapture).first();
        writeTransaction.removeLabelFromNode(50, nodeId);
        writeTransaction.removeLabelFromNode(51, nodeId);
        writeTransaction.removeLabelFromNode(52, nodeId);
        writeTransaction.addLabelToNode(60, nodeId);
        writeTransaction.addLabelToNode(61, nodeId);
        writeTransaction.addLabelToNode(62, nodeId);
        this.prepareAndCommit(writeTransaction);
        commandCapture.visitCapturedCommands(new Visitor<XaCommand, RuntimeException>(){

            public boolean visit(XaCommand element) throws RuntimeException {
                if (element instanceof Command.NodeCommand) {
                    Command.NodeCommand cmd = (Command.NodeCommand)element;
                    DynamicRecord before = (DynamicRecord)cmd.getBefore().getDynamicLabelRecords().iterator().next();
                    DynamicRecord after = (DynamicRecord)cmd.getAfter().getDynamicLabelRecords().iterator().next();
                    Assert.assertThat((Object)before.getId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)after.getId()));
                    Assert.assertThat((Object)after.inUse(), (Matcher)org.hamcrest.Matchers.equalTo((Object)true));
                }
                return true;
            }
        });
    }

    @Test
    public void shouldRemoveSchemaRuleWhenRollingBackTransaction() throws Exception {
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        long ruleId = this.neoStore.getSchemaStore().nextId();
        writeTransaction.createSchemaRule((SchemaRule)IndexRule.indexRule((long)ruleId, (int)10, (int)7, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        writeTransaction.prepare();
        writeTransaction.rollback();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.cacheAccessBackDoor});
    }

    @Test
    public void shouldWriteProperBeforeAndAfterPropertyRecordsWhenAddingProperty() throws Exception {
        Visitor<XaCommand, RuntimeException> verifier = new Visitor<XaCommand, RuntimeException>(){

            public boolean visit(XaCommand element) {
                if (element instanceof Command.PropertyCommand) {
                    PropertyRecord before = ((Command.PropertyCommand)element).getBefore();
                    Assert.assertFalse((boolean)before.inUse());
                    Assert.assertEquals(Collections.emptyList(), (Object)before.getPropertyBlocks());
                    PropertyRecord after = ((Command.PropertyCommand)element).getAfter();
                    Assert.assertTrue((boolean)after.inUse());
                    Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)after.getPropertyBlocks()));
                }
                return true;
            }
        };
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing, verifier).first();
        int nodeId = 1;
        writeTransaction.setCommitTxId((long)nodeId);
        writeTransaction.nodeCreate((long)nodeId);
        int propertyKey = 1;
        Integer value = 5;
        writeTransaction.nodeAddProperty((long)nodeId, propertyKey, (Object)value);
        writeTransaction.doPrepare();
    }

    @Test
    public void shouldConvertAddedPropertyToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        CapturingIndexingService indexingService = new CapturingIndexingService();
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(indexingService).first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        this.prepareAndCommit(writeTransaction);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])none), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])none)}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertChangedPropertyToNodePropertyUpdates() throws Exception {
        int nodeId = 0;
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate((long)nodeId);
        DefinedProperty property1 = writeTransaction.nodeAddProperty((long)nodeId, propertyKey1, (Object)value1);
        DefinedProperty property2 = writeTransaction.nodeAddProperty((long)nodeId, propertyKey2, (Object)value2);
        this.prepareAndCommit(writeTransaction);
        CapturingIndexingService indexingService = new CapturingIndexingService();
        String newValue1 = "new";
        String newValue2 = "new 2";
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeChangeProperty((long)nodeId, property1.propertyKeyId(), (Object)newValue1);
        writeTransaction.nodeChangeProperty((long)nodeId, property2.propertyKeyId(), (Object)newValue2);
        this.prepareAndCommit(writeTransaction);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.change((long)nodeId, (int)propertyKey1, (Object)value1, (long[])none, (Object)newValue1, (long[])none), NodePropertyUpdate.change((long)nodeId, (int)propertyKey2, (Object)value2, (long[])none, (Object)newValue2, (long[])none)}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertRemovedPropertyToNodePropertyUpdates() throws Exception {
        int nodeId = 0;
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate((long)nodeId);
        DefinedProperty property1 = writeTransaction.nodeAddProperty((long)nodeId, propertyKey1, (Object)value1);
        DefinedProperty property2 = writeTransaction.nodeAddProperty((long)nodeId, propertyKey2, (Object)value2);
        this.prepareAndCommit(writeTransaction);
        CapturingIndexingService indexingService = new CapturingIndexingService();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeRemoveProperty((long)nodeId, property1.propertyKeyId());
        writeTransaction.nodeRemoveProperty((long)nodeId, property2.propertyKeyId());
        this.prepareAndCommit(writeTransaction);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])none), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])none)}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertLabelAdditionToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId = 3;
        long[] labelIds = new long[]{labelId};
        String value1 = LONG_STRING;
        byte[] value2 = LONG_STRING.getBytes();
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        this.prepareAndCommit(writeTransaction);
        CapturingIndexingService indexingService = new CapturingIndexingService();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(indexingService).first();
        writeTransaction.addLabelToNode(labelId, nodeId);
        this.prepareAndCommit(writeTransaction);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])labelIds), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])labelIds)}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertMixedLabelAdditionAndSetPropertyToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.addLabelToNode(labelId1, nodeId);
        this.prepareAndCommit(writeTransaction);
        CapturingIndexingService indexingService = new CapturingIndexingService();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        writeTransaction.addLabelToNode(labelId2, nodeId);
        this.prepareAndCommit(writeTransaction);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId2}), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2}), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId1, labelId2})}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertLabelRemovalToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId = 3;
        long[] labelIds = new long[]{labelId};
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        writeTransaction.addLabelToNode(labelId, nodeId);
        this.prepareAndCommit(writeTransaction);
        CapturingIndexingService indexingService = new CapturingIndexingService();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(indexingService).first();
        writeTransaction.removeLabelFromNode(labelId, nodeId);
        this.prepareAndCommit(writeTransaction);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])labelIds), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])labelIds)}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertMixedLabelRemovalAndRemovePropertyToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        DefinedProperty property1 = writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        writeTransaction.addLabelToNode(labelId1, nodeId);
        writeTransaction.addLabelToNode(labelId2, nodeId);
        this.prepareAndCommit(writeTransaction);
        CapturingIndexingService indexingService = new CapturingIndexingService();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeRemoveProperty(nodeId, property1.propertyKeyId());
        writeTransaction.removeLabelFromNode(labelId2, nodeId);
        this.prepareAndCommit(writeTransaction);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId1, labelId2}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2})}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertMixedLabelRemovalAndAddPropertyToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.addLabelToNode(labelId1, nodeId);
        writeTransaction.addLabelToNode(labelId2, nodeId);
        this.prepareAndCommit(writeTransaction);
        CapturingIndexingService indexingService = new CapturingIndexingService();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        writeTransaction.removeLabelFromNode(labelId2, nodeId);
        this.prepareAndCommit(writeTransaction);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId1}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId2}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2})}), (Object)indexingService.updates);
    }

    @Test
    public void shouldUpdateHighIdsOnRecoveredTransaction() throws Exception {
        NeoStoreTransaction tx = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int nodeId = 5;
        int relId = 10;
        int relationshipType = 3;
        int propertyKeyId = 4;
        int ruleId = 8;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken(relationshipType, "type");
        tx.relationshipCreate((long)relId, 0, (long)nodeId, (long)nodeId);
        tx.relAddProperty((long)relId, propertyKeyId, (Object)new long[]{0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L});
        tx.createPropertyKeyToken("key", propertyKeyId);
        tx.nodeAddProperty((long)nodeId, propertyKeyId, (Object)"something long and nasty that requires dynamic records for sure I would think and hope. Ok then \u00e5\u00e4\u00f6%!=");
        for (int i = 0; i < 10; ++i) {
            tx.addLabelToNode(10000 + i, (long)nodeId);
        }
        tx.createSchemaRule((SchemaRule)IndexRule.indexRule((long)ruleId, (int)100, (int)propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        this.prepareAndCommitRecovered(tx);
        Assert.assertEquals((String)"NodeStore", (long)(nodeId + 1), (long)this.neoStore.getNodeStore().getHighId());
        Assert.assertEquals((String)"DynamicNodeLabelStore", (long)2L, (long)this.neoStore.getNodeStore().getDynamicLabelStore().getHighId());
        Assert.assertEquals((String)"RelationshipStore", (long)(relId + 1), (long)this.neoStore.getRelationshipStore().getHighId());
        Assert.assertEquals((String)"RelationshipTypeStore", (long)(relationshipType + 1), (long)this.neoStore.getRelationshipTypeStore().getHighId());
        Assert.assertEquals((String)"RelationshipType NameStore", (long)2L, (long)this.neoStore.getRelationshipTypeStore().getNameStore().getHighId());
        Assert.assertEquals((String)"PropertyStore", (long)2L, (long)this.neoStore.getPropertyStore().getHighId());
        Assert.assertEquals((String)"PropertyStore DynamicStringStore", (long)2L, (long)this.neoStore.getPropertyStore().getStringStore().getHighId());
        Assert.assertEquals((String)"PropertyStore DynamicArrayStore", (long)2L, (long)this.neoStore.getPropertyStore().getArrayStore().getHighId());
        Assert.assertEquals((String)"PropertyIndexStore", (long)(propertyKeyId + 1), (long)this.neoStore.getPropertyKeyTokenStore().getHighId());
        Assert.assertEquals((String)"PropertyKeyToken NameStore", (long)2L, (long)this.neoStore.getPropertyStore().getPropertyKeyTokenStore().getNameStore().getHighId());
        Assert.assertEquals((String)"SchemaStore", (long)(ruleId + 1), (long)this.neoStore.getSchemaStore().getHighId());
    }

    @Test
    public void createdSchemaRuleRecordMustBeWrittenHeavy() throws Exception {
        Visitor<XaCommand, RuntimeException> verifier = this.heavySchemaRuleVerifier();
        NeoStoreTransaction tx = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing, verifier).first();
        long ruleId = 0L;
        int labelId = 5;
        int propertyKeyId = 7;
        IndexRule rule = IndexRule.indexRule((long)ruleId, (int)labelId, (int)propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        tx.createSchemaRule((SchemaRule)rule);
        this.prepareAndCommit(tx);
    }

    @Test
    public void shouldWriteProperPropertyRecordsWhenOnlyChangingLinkage() throws Exception {
        NeoStoreTransaction tx = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        int nodeId = 0;
        tx.nodeCreate((long)nodeId);
        int index = 0;
        tx.nodeAddProperty((long)nodeId, index, (Object)this.string(70));
        this.prepareAndCommit(tx);
        Visitor<XaCommand, RuntimeException> verifier = new Visitor<XaCommand, RuntimeException>(){

            public boolean visit(XaCommand element) {
                if (element instanceof Command.PropertyCommand) {
                    Command.PropertyCommand propertyCommand = (Command.PropertyCommand)element;
                    this.verifyPropertyRecord(propertyCommand.getBefore());
                    this.verifyPropertyRecord(propertyCommand.getAfter());
                    return true;
                }
                return false;
            }

            private void verifyPropertyRecord(PropertyRecord record) {
                if (record.getPrevProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                    for (PropertyBlock block : record.getPropertyBlocks()) {
                        Assert.assertTrue((boolean)block.isLight());
                    }
                }
            }
        };
        tx = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing, verifier).first();
        int index2 = 1;
        tx.nodeAddProperty((long)nodeId, index2, (Object)this.string(40));
        this.prepareAndCommit(tx);
    }

    @Test
    public void shouldCreateEqualNodePropertyUpdatesOnRecoveryOfCreatedNode() throws Exception {
        long nodeId = 0L;
        int labelId = 5;
        int propertyKeyId = 7;
        NodePropertyUpdate expectedUpdate = NodePropertyUpdate.add((long)nodeId, (int)propertyKeyId, (Object)"Neo", (long[])new long[]{labelId});
        long ruleId = 0L;
        NeoStoreTransaction tx = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        IndexRule rule = IndexRule.indexRule((long)ruleId, (int)labelId, (int)propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        tx.createSchemaRule((SchemaRule)rule);
        this.prepareAndCommit(tx);
        IndexingService index = (IndexingService)Mockito.mock(IndexingService.class);
        IteratorCollector<NodePropertyUpdate> indexUpdates = new IteratorCollector<NodePropertyUpdate>(0);
        ((IndexingService)Mockito.doAnswer(indexUpdates).when((Object)index)).updateIndexes((IndexUpdates)Matchers.any(IndexUpdates.class));
        CommandCapturingVisitor commandCapturingVisitor = new CommandCapturingVisitor();
        tx = (NeoStoreTransaction)this.newWriteTransaction(index, commandCapturingVisitor).first();
        tx.nodeCreate(nodeId);
        tx.addLabelToNode(labelId, nodeId);
        tx.nodeAddProperty(nodeId, propertyKeyId, (Object)"Neo");
        this.prepareAndCommit(tx);
        ((IndexingService)Mockito.verify((Object)index, (VerificationMode)Mockito.times((int)1))).updateIndexes((IndexUpdates)Matchers.any(IndexUpdates.class));
        indexUpdates.assertContent(expectedUpdate);
        Mockito.reset((Object[])new IndexingService[]{index});
        indexUpdates = new IteratorCollector(0);
        ((IndexingService)Mockito.doAnswer(indexUpdates).when((Object)index)).updateIndexes((IndexUpdates)Matchers.any(IndexUpdates.class));
        tx = (NeoStoreTransaction)this.newWriteTransaction(index).first();
        commandCapturingVisitor.injectInto(tx);
        this.prepareAndCommitRecovered(tx);
        ((IndexingService)Mockito.verify((Object)index, (VerificationMode)Mockito.times((int)1))).updateIndexes((IndexUpdates)Matchers.any(IndexUpdates.class));
        indexUpdates.assertContent(expectedUpdate);
    }

    @Test
    public void shouldLockUpdatedNodes() throws Exception {
        NodeStore nodeStore = this.neoStore.getNodeStore();
        long[] nodes = new long[]{nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId()};
        NeoStoreTransaction tx = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        for (int i = 1; i < nodes.length - 1; ++i) {
            tx.nodeCreate(nodes[i]);
        }
        tx.nodeAddProperty(nodes[3], 0, (Object)"old");
        tx.nodeAddProperty(nodes[4], 0, (Object)"old");
        this.prepareAndCommit(tx);
        Mockito.reset((Object[])new LockService[]{this.locks});
        tx = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing).first();
        tx.nodeCreate(nodes[0]);
        tx.addLabelToNode(0, nodes[1]);
        tx.nodeAddProperty(nodes[2], 0, (Object)"value");
        tx.nodeChangeProperty(nodes[3], 0, (Object)"value");
        tx.nodeRemoveProperty(nodes[4], 0);
        tx.nodeDelete(nodes[5]);
        tx.nodeCreate(nodes[6]);
        tx.addLabelToNode(0, nodes[6]);
        tx.nodeAddProperty(nodes[6], 0, (Object)"value");
        this.prepareAndCommit(tx);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[0], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[1], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[2], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[3], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[4], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[5], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[6], LockService.LockType.WRITE_LOCK);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithDifferentTypes() throws Exception {
        this.instantiateNeoStore(50);
        Pair<NeoStoreTransaction, NeoStoreTransactionContext> transactionContextPair = this.newWriteTransaction();
        NeoStoreTransaction tx = (NeoStoreTransaction)transactionContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionContextPair.other();
        int nodeId = (int)this.nextId(IdType.NODE);
        int typeA = 0;
        int typeB = 1;
        int typeC = 2;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken(typeA, "A");
        this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 6);
        this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 7);
        tx.createRelationshipTypeToken(typeB, "B");
        this.createRelationships(tx, nodeId, typeB, Direction.OUTGOING, 8);
        this.createRelationships(tx, nodeId, typeB, Direction.INCOMING, 9);
        tx.createRelationshipTypeToken(typeC, "C");
        this.createRelationships(tx, nodeId, typeC, Direction.OUTGOING, 10);
        this.createRelationships(tx, nodeId, typeC, Direction.INCOMING, 10);
        Assert.assertFalse((boolean)tx.nodeLoadLight((long)nodeId).isDense());
        this.createRelationships(tx, nodeId, typeC, Direction.INCOMING, 1);
        Assert.assertTrue((boolean)tx.nodeLoadLight((long)nodeId).isDense());
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 6, 7);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeB, 8, 9);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 10, 11);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithTheSameTypeDifferentDirection() throws Exception {
        this.instantiateNeoStore(49);
        Pair<NeoStoreTransaction, NeoStoreTransactionContext> transactionContextPair = this.newWriteTransaction();
        NeoStoreTransaction tx = (NeoStoreTransaction)transactionContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionContextPair.other();
        int nodeId = (int)this.nextId(IdType.NODE);
        int typeA = 0;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken(typeA, "A");
        this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 24);
        this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 25);
        Assert.assertFalse((boolean)tx.nodeLoadLight((long)nodeId).isDense());
        this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 1);
        Assert.assertTrue((boolean)tx.nodeLoadLight((long)nodeId).isDense());
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 24, 26);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithTheSameTypeSameDirection() throws Exception {
        this.instantiateNeoStore(8);
        Pair<NeoStoreTransaction, NeoStoreTransactionContext> transactionContextPair = this.newWriteTransaction();
        NeoStoreTransaction tx = (NeoStoreTransaction)transactionContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionContextPair.other();
        int nodeId = (int)this.nextId(IdType.NODE);
        int typeA = 0;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken(typeA, "A");
        this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 8);
        Assert.assertFalse((boolean)tx.nodeLoadLight((long)nodeId).isDense());
        this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 1);
        Assert.assertTrue((boolean)tx.nodeLoadLight((long)nodeId).isDense());
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 9, 0);
    }

    @Test
    public void shouldMaintainCorrectDataWhenDeletingFromDenseNodeWithOneType() throws Exception {
        this.instantiateNeoStore(13);
        Pair<NeoStoreTransaction, NeoStoreTransactionContext> transactionContextPair = this.newWriteTransaction();
        NeoStoreTransaction tx = (NeoStoreTransaction)transactionContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionContextPair.other();
        int nodeId = (int)this.nextId(IdType.NODE);
        int typeA = 0;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken(typeA, "A");
        long[] relationshipsCreated = this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 15);
        this.deleteRelationship(tx, relationshipsCreated[0]);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 0, 14);
    }

    @Test
    public void shouldMaintainCorrectDataWhenDeletingFromDenseNodeWithManyTypes() throws Exception {
        this.instantiateNeoStore(1);
        Pair<NeoStoreTransaction, NeoStoreTransactionContext> transactionAndContextPair = this.newWriteTransaction();
        NeoStoreTransaction tx = (NeoStoreTransaction)transactionAndContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionAndContextPair.other();
        int nodeId = (int)this.nextId(IdType.NODE);
        int typeA = 0;
        int typeB = 12;
        int typeC = 600;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken(typeA, "A");
        long[] relationshipsCreatedAIncoming = this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 1);
        long[] relationshipsCreatedAOutgoing = this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 1);
        tx.createRelationshipTypeToken(typeB, "B");
        long[] relationshipsCreatedBIncoming = this.createRelationships(tx, nodeId, typeB, Direction.INCOMING, 1);
        long[] relationshipsCreatedBOutgoing = this.createRelationships(tx, nodeId, typeB, Direction.OUTGOING, 1);
        tx.createRelationshipTypeToken(typeC, "C");
        long[] relationshipsCreatedCIncoming = this.createRelationships(tx, nodeId, typeC, Direction.INCOMING, 1);
        long[] relationshipsCreatedCOutgoing = this.createRelationships(tx, nodeId, typeC, Direction.OUTGOING, 1);
        this.deleteRelationship(tx, relationshipsCreatedAIncoming[0]);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 1, 0);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeB, 1, 1);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 1);
        this.deleteRelationship(tx, relationshipsCreatedAOutgoing[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeA);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeB, 1, 1);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 1);
        this.deleteRelationship(tx, relationshipsCreatedBIncoming[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeA);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeB, 1, 0);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 1);
        this.deleteRelationship(tx, relationshipsCreatedBOutgoing[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeA);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeB);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 1);
        this.deleteRelationship(tx, relationshipsCreatedCIncoming[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeA);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeB);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 0);
        this.deleteRelationship(tx, relationshipsCreatedCOutgoing[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeA);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeB);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, tx.nodeLoadLight((long)nodeId), typeC);
    }

    @Test
    public void movingBilaterallyOfTheDenseNodeThresholdIsConsistent() throws Exception {
        long[] relationshipsOfTypeB;
        this.instantiateNeoStore(10);
        long nodeId = this.neoStore.getNodeStore().nextId();
        NeoStoreTransaction writeTransaction = (NeoStoreTransaction)this.newWriteTransaction().first();
        writeTransaction.nodeCreate(nodeId);
        int typeA = 0;
        writeTransaction.createRelationshipTypeToken(typeA, "A");
        this.createRelationships(writeTransaction, nodeId, typeA, Direction.INCOMING, 20);
        this.prepareAndCommit(writeTransaction);
        int typeB = 1;
        writeTransaction.createRelationshipTypeToken(typeB, "B");
        CommandCapturingVisitor commandCapture = new CommandCapturingVisitor();
        writeTransaction = (NeoStoreTransaction)this.newWriteTransaction(this.mockIndexing, commandCapture).first();
        for (long relationshipToDelete : relationshipsOfTypeB = this.createRelationships(writeTransaction, nodeId, typeB, Direction.OUTGOING, 5)) {
            this.deleteRelationship(writeTransaction, relationshipToDelete);
        }
        this.prepareAndCommit(writeTransaction);
        final AtomicBoolean foundRelationshipGroupInUse = new AtomicBoolean();
        commandCapture.visitCapturedCommands(new Visitor<XaCommand, RuntimeException>(){

            public boolean visit(XaCommand element) throws RuntimeException {
                if (element instanceof Command.RelationshipGroupCommand && ((Command.RelationshipGroupCommand)element).getRecord().inUse()) {
                    if (!foundRelationshipGroupInUse.get()) {
                        foundRelationshipGroupInUse.set(true);
                    } else {
                        Assert.fail();
                    }
                }
                return true;
            }
        });
        Assert.assertTrue((String)"Did not create relationship group command", (boolean)foundRelationshipGroupInUse.get());
    }

    @Test
    public void shouldSortRelationshipGroups() throws Exception {
        this.instantiateNeoStore(1);
        int type5 = 5;
        int type10 = 10;
        int type15 = 15;
        NeoStoreTransaction tx = (NeoStoreTransaction)this.newWriteTransaction().first();
        this.neoStore.getRelationshipTypeStore().setHighId(16L);
        tx.createRelationshipTypeToken(type5, "5");
        tx.createRelationshipTypeToken(type10, "10");
        tx.createRelationshipTypeToken(type15, "15");
        this.prepareAndCommit(tx);
        long nodeId = this.neoStore.getNodeStore().nextId();
        NeoStoreTransaction tx2 = (NeoStoreTransaction)this.newWriteTransaction().first();
        long otherNode1Id = this.neoStore.getNodeStore().nextId();
        long otherNode2Id = this.neoStore.getNodeStore().nextId();
        tx2.nodeCreate(nodeId);
        tx2.nodeCreate(otherNode1Id);
        tx2.nodeCreate(otherNode2Id);
        tx2.relationshipCreate(this.neoStore.getRelationshipStore().nextId(), type10, nodeId, otherNode1Id);
        tx2.relationshipCreate(this.neoStore.getRelationshipStore().nextId(), type10, nodeId, otherNode2Id);
        this.prepareAndCommit(tx2);
        this.assertRelationshipGroupsInOrder(nodeId, type10);
        tx2 = (NeoStoreTransaction)this.newWriteTransaction().first();
        long otherNodeId = this.neoStore.getNodeStore().nextId();
        tx2.nodeCreate(otherNodeId);
        tx2.relationshipCreate(this.neoStore.getRelationshipStore().nextId(), type5, nodeId, otherNodeId);
        this.prepareAndCommit(tx2);
        this.assertRelationshipGroupsInOrder(nodeId, type5, type10);
        tx2 = (NeoStoreTransaction)this.newWriteTransaction().first();
        otherNodeId = this.neoStore.getNodeStore().nextId();
        tx2.nodeCreate(otherNodeId);
        tx2.relationshipCreate(this.neoStore.getRelationshipStore().nextId(), type15, nodeId, otherNodeId);
        this.prepareAndCommit(tx2);
        this.assertRelationshipGroupsInOrder(nodeId, type5, type10, type15);
    }

    private void assertRelationshipGroupsInOrder(long nodeId, int ... types) {
        NodeRecord node = this.neoStore.getNodeStore().getRecord(nodeId);
        Assert.assertTrue((String)("Node should be dense, is " + node), (boolean)node.isDense());
        long groupId = node.getNextRel();
        int cursor = 0;
        ArrayList<RelationshipGroupRecord> seen = new ArrayList<RelationshipGroupRecord>();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord group = this.neoStore.getRelationshipGroupStore().getRecord(groupId);
            seen.add(group);
            Assert.assertEquals((String)("Invalid type, seen groups so far " + seen), (long)types[cursor++], (long)group.getType());
            groupId = group.getNext();
        }
        Assert.assertEquals((String)("Not enough relationship group records found in chain for " + node), (long)types.length, (long)cursor);
    }

    private static void assertRelationshipGroupDoesNotExist(NeoStoreTransactionContext txCtx, NodeRecord node, int type) {
        Assert.assertNull((Object)txCtx.getRelationshipGroup(node, type));
    }

    private static void assertDenseRelationshipCounts(NeoStoreTransaction tx, NeoStoreTransactionContext txCtx, long nodeId, int type, int outCount, int inCount) {
        RelationshipRecord rel;
        RelationshipGroupRecord group = (RelationshipGroupRecord)txCtx.getRelationshipGroup(tx.nodeLoadLight(nodeId), type).forReadingData();
        Assert.assertNotNull((Object)group);
        long relId = group.getFirstOut();
        if (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            rel = tx.relLoadLight(relId);
            Assert.assertEquals((String)"Stored relationship count for OUTGOING differs", (long)outCount, (long)rel.getFirstPrevRel());
            Assert.assertEquals((String)"Manually counted relationships for OUTGOING differs", (long)outCount, (long)NeoStoreTransactionTest.manuallyCountRelationships(tx, nodeId, relId));
        }
        if ((relId = group.getFirstIn()) != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            rel = tx.relLoadLight(relId);
            Assert.assertEquals((String)"Stored relationship count for INCOMING differs", (long)inCount, (long)rel.getSecondPrevRel());
            Assert.assertEquals((String)"Manually counted relationships for INCOMING differs", (long)inCount, (long)NeoStoreTransactionTest.manuallyCountRelationships(tx, nodeId, relId));
        }
    }

    private static int manuallyCountRelationships(NeoStoreTransaction tx, long nodeId, long firstRelId) {
        int count = 0;
        long relId = firstRelId;
        while (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            ++count;
            RelationshipRecord record = tx.relLoadLight(relId);
            relId = record.getFirstNode() == nodeId ? record.getFirstNextRel() : record.getSecondNextRel();
        }
        return count;
    }

    private long nextId(IdType type) {
        return this.idGeneratorFactory.get(type).nextId();
    }

    private long[] createRelationships(NeoStoreTransaction tx, long nodeId, int type, Direction direction, int count) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            long relId;
            long otherNodeId = this.nextId(IdType.NODE);
            tx.nodeCreate(otherNodeId);
            long first = direction == Direction.OUTGOING ? nodeId : otherNodeId;
            long other = direction == Direction.INCOMING ? nodeId : otherNodeId;
            result[i] = relId = this.nextId(IdType.RELATIONSHIP);
            tx.relationshipCreate(relId, type, first, other);
        }
        return result;
    }

    private void deleteRelationship(NeoStoreTransaction tx, long relId) {
        tx.relDelete(relId);
    }

    private String string(int length) {
        StringBuilder result = new StringBuilder();
        int ch = 97;
        for (int i = 0; i < length; ++i) {
            result.append((char)(ch + i % 10));
        }
        return result.toString();
    }

    @Before
    public void before() throws Exception {
        this.instantiateNeoStore(Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue()));
    }

    private void instantiateNeoStore(int denseNodeThreshold) {
        if (this.neoStore != null) {
            this.fs.clear();
        }
        this.config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.dense_node_threshold.name(), "" + denseNodeThreshold}));
        StoreFactory storeFactory = new StoreFactory(this.config, (IdGeneratorFactory)this.idGeneratorFactory, (WindowPoolFactory)this.windowPoolFactory, (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
        this.neoStore = storeFactory.createNeoStore(new File("neostore"));
        this.lockMocks.clear();
        this.locks = (LockService)Mockito.mock(LockService.class, (Answer)new Answer(){

            public synchronized Object answer(InvocationOnMock invocation) throws Throwable {
                if (invocation.getMethod().getName().equals("acquireNodeLock")) {
                    Lock mock = (Lock)Mockito.mock(Lock.class, (Answer)new Answer(){

                        public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                            return null;
                        }
                    });
                    NeoStoreTransactionTest.this.lockMocks.add(mock);
                    return mock;
                }
                return null;
            }
        });
        this.cacheAccessBackDoor = (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class);
    }

    @After
    public void shouldReleaseAllLocks() {
        for (Lock lock : this.lockMocks) {
            ((Lock)Mockito.verify((Object)lock)).release();
        }
    }

    private Pair<NeoStoreTransaction, NeoStoreTransactionContext> newWriteTransaction() {
        return this.newWriteTransaction(this.mockIndexing);
    }

    private Pair<NeoStoreTransaction, NeoStoreTransactionContext> newWriteTransaction(IndexingService indexing) {
        return this.newWriteTransaction(indexing, nullVisitor);
    }

    private Pair<NeoStoreTransaction, NeoStoreTransactionContext> newWriteTransaction(IndexingService indexing, Visitor<XaCommand, RuntimeException> verifier) {
        VerifyingXaLogicalLog log = new VerifyingXaLogicalLog(this.fs.get(), verifier);
        NeoStoreTransactionContext context = new NeoStoreTransactionContext((NeoStoreTransactionContextSupplier)Mockito.mock(NeoStoreTransactionContextSupplier.class), this.neoStore);
        Mockito.when((Object)this.transactionState.locks()).thenReturn(Mockito.mock(Locks.Client.class));
        context.bind(this.transactionState);
        NeoStoreTransaction result = new NeoStoreTransaction(0L, (XaLogicalLog)log, this.neoStore, this.cacheAccessBackDoor, indexing, NO_LABEL_SCAN_STORE, new IntegrityValidator(this.neoStore, indexing), this.kernelTransaction, this.locks, context);
        result.setIdentifier(0);
        result.setCommitTxId(this.neoStore.getLastCommittedTx() + 1L);
        return Pair.of((Object)result, (Object)context);
    }

    private Visitor<XaCommand, RuntimeException> heavySchemaRuleVerifier() {
        return new Visitor<XaCommand, RuntimeException>(){

            public boolean visit(XaCommand element) {
                for (DynamicRecord record : ((Command.SchemaRuleCommand)element).getRecordsAfter()) {
                    Assert.assertFalse((String)(record + " should have been heavy"), (boolean)record.isLight());
                }
                return true;
            }
        };
    }

    private void prepareAndCommitRecovered(NeoStoreTransaction tx) throws Exception {
        tx.setRecovered();
        this.prepareAndCommit(tx);
    }

    private void prepareAndCommit(NeoStoreTransaction tx) throws Exception {
        tx.doPrepare();
        tx.doCommit();
    }

    private class IteratorCollector<T>
    implements Answer<Object> {
        private final int arg;
        private final List<T> elements = new ArrayList<T>();

        public IteratorCollector(int arg) {
            this.arg = arg;
        }

        @SafeVarargs
        public final void assertContent(T ... expected) {
            Assert.assertEquals(Arrays.asList(expected), this.elements);
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Iterator iterator = invocation.getArguments()[this.arg];
            if (iterator instanceof Iterable) {
                iterator = ((Iterable)((Object)iterator)).iterator();
            }
            if (iterator instanceof Iterator) {
                this.collect(iterator);
            }
            return null;
        }

        private void collect(Iterator<T> iterator) {
            while (iterator.hasNext()) {
                this.elements.add(iterator.next());
            }
        }
    }

    private class CapturingIndexingService
    extends IndexingService {
        private final Set<NodePropertyUpdate> updates;

        public CapturingIndexingService() {
            super(null, (SchemaIndexProviderMap)new DefaultSchemaIndexProviderMap(SchemaIndexProvider.NO_INDEX_PROVIDER), (IndexStoreView)new NeoStoreIndexStoreView(NeoStoreTransactionTest.this.locks, NeoStoreTransactionTest.this.neoStore), null, (UpdateableSchemaState)new KernelSchemaStateStore(), (Logging)new SingleLoggingService(StringLogger.DEV_NULL), IndexingService.NO_MONITOR);
            this.updates = new HashSet<NodePropertyUpdate>();
        }

        public void updateIndexes(IndexUpdates updates) {
            this.updates.addAll(IteratorUtil.asCollection((Iterable)updates));
        }
    }

    private static class CommandCapturingVisitor
    implements Visitor<XaCommand, RuntimeException> {
        private final Collection<XaCommand> commands = new ArrayList<XaCommand>();

        private CommandCapturingVisitor() {
        }

        public boolean visit(XaCommand element) throws RuntimeException {
            this.commands.add(element);
            return true;
        }

        public void injectInto(NeoStoreTransaction tx) {
            for (XaCommand command : this.commands) {
                tx.injectCommand(command);
            }
        }

        public void visitCapturedCommands(Visitor<XaCommand, RuntimeException> visitor) {
            for (XaCommand command : this.commands) {
                visitor.visit((Object)command);
            }
        }
    }

    private static class VerifyingXaLogicalLog
    extends XaLogicalLog {
        private final Visitor<XaCommand, RuntimeException> verifier;

        public VerifyingXaLogicalLog(FileSystemAbstraction fs, Visitor<XaCommand, RuntimeException> verifier) {
            super(new File("log"), null, (XaCommandReaderFactory)Mockito.mock(XaCommandReaderFactory.class), (XaCommandWriterFactory)Mockito.mock(XaCommandWriterFactory.class), null, fs, new Monitors(), (Logging)new SingleLoggingService(StringLogger.DEV_NULL), LogPruneStrategies.NO_PRUNING, null, (KernelHealth)Mockito.mock(KernelHealth.class), 0x1900000L, InjectedTransactionValidator.ALLOW_ALL, Functions.identity(), Functions.identity());
            this.verifier = verifier;
        }

        public synchronized void writeCommand(XaCommand command, int identifier) throws IOException {
            this.verifier.visit((Object)command);
        }
    }
}

