/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.ShortArray;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.labels.DynamicNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandReaderV1;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;

public class NodeCommandTest {
    private NodeStore nodeStore;
    private XaCommandReader commandReader = new PhysicalLogNeoXaCommandReaderV1(ByteBuffer.allocate(64));
    private XaCommandWriter commandWriter = new PhysicalLogNeoXaCommandWriter();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldSerializeAndDeserializeUnusedRecords() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeCreatedRecord() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setCreated();
        after.setInUse(true);
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeUpdatedRecord() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeInlineLabels() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)after);
        nodeLabels.add(1337L, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeDynamicRecordLabels() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)after);
        for (int i = 10; i < 100; ++i) {
            nodeLabels.add((long)i, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
        }
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeDynamicRecordsRemoved() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        List<DynamicRecord> beforeDyn = Arrays.asList(DynamicRecord.dynamicRecord((long)0L, (boolean)true, (boolean)true, (long)-1L, (int)ShortArray.LONG.intValue(), (byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}));
        before.setLabelField(DynamicNodeLabels.dynamicPointer(beforeDyn), beforeDyn);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        List<DynamicRecord> dynamicRecords = Arrays.asList(DynamicRecord.dynamicRecord((long)0L, (boolean)false, (boolean)true, (long)-1L, (int)ShortArray.LONG.intValue(), (byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}));
        after.setLabelField(DynamicNodeLabels.dynamicPointer(dynamicRecords), dynamicRecords);
        Command.NodeCommand cmd = new Command.NodeCommand();
        cmd.init(before, after);
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        this.commandWriter.write((XaCommand)cmd, (LogBuffer)buffer);
        Command.NodeCommand result = (Command.NodeCommand)this.commandReader.read((ReadableByteChannel)buffer);
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)cmd));
        MatcherAssert.assertThat((Object)result.getMode(), (Matcher)IsEqual.equalTo((Object)cmd.getMode()));
        MatcherAssert.assertThat((Object)result.getBefore(), (Matcher)IsEqual.equalTo((Object)cmd.getBefore()));
        MatcherAssert.assertThat((Object)result.getAfter(), (Matcher)IsEqual.equalTo((Object)cmd.getAfter()));
        MatcherAssert.assertThat((Object)result.getBefore().getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)cmd.getBefore().getDynamicLabelRecords()));
        MatcherAssert.assertThat((Object)result.getAfter().getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)cmd.getAfter().getDynamicLabelRecords()));
    }

    private void assertSerializationWorksFor(Command.NodeCommand cmd) throws IOException {
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        this.commandWriter.write((XaCommand)cmd, (LogBuffer)buffer);
        Command.NodeCommand result = (Command.NodeCommand)this.commandReader.read((ReadableByteChannel)buffer);
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)cmd));
        MatcherAssert.assertThat((Object)result.getMode(), (Matcher)IsEqual.equalTo((Object)cmd.getMode()));
        MatcherAssert.assertThat((Object)result.getBefore(), (Matcher)IsEqual.equalTo((Object)cmd.getBefore()));
        MatcherAssert.assertThat((Object)result.getAfter(), (Matcher)IsEqual.equalTo((Object)cmd.getAfter()));
        MatcherAssert.assertThat(this.labels(result.getBefore()), (Matcher)IsEqual.equalTo(this.labels(cmd.getBefore())));
        MatcherAssert.assertThat(this.labels(result.getAfter()), (Matcher)IsEqual.equalTo(this.labels(cmd.getAfter())));
        MatcherAssert.assertThat((Object)result.getBefore().getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)result.getBefore().getDynamicLabelRecords()));
        MatcherAssert.assertThat((Object)result.getAfter().getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)result.getAfter().getDynamicLabelRecords()));
    }

    private Set<Integer> labels(NodeRecord record) {
        long[] rawLabels = NodeLabelsField.parseLabelsField((NodeRecord)record).get(this.nodeStore);
        HashSet<Integer> labels = new HashSet<Integer>(rawLabels.length);
        for (long label : rawLabels) {
            labels.add(IoPrimitiveUtils.safeCastLongToInt((long)label));
        }
        return labels;
    }

    @Before
    public void before() throws Exception {
        StoreFactory storeFactory = new StoreFactory(new Config(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
        File storeFile = new File("nodestore");
        storeFactory.createNodeStore(storeFile);
        this.nodeStore = storeFactory.newNodeStore(storeFile);
    }

    @After
    public void after() throws Exception {
        this.nodeStore.close();
    }
}

