/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.xa.RecordChangeSet;

public class RecordChangeSetTest {
    @Test
    public void shouldStartWithSetsInitializedAndEmpty() throws Exception {
        RecordChangeSet changeSet = new RecordChangeSet((NeoStore)Mockito.mock(NeoStore.class));
        Assert.assertEquals((long)0L, (long)changeSet.getNodeRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getPropertyRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getRelRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getSchemaRuleChanges().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getRelGroupRecords().changeSize());
    }

    @Test
    public void shouldClearStateOnClose() throws Exception {
        NeoStore mockStore = (NeoStore)Mockito.mock(NeoStore.class);
        Mockito.when((Object)mockStore.getNodeStore()).thenReturn(Mockito.mock(NodeStore.class));
        Mockito.when((Object)mockStore.getRelationshipStore()).thenReturn(Mockito.mock(RelationshipStore.class));
        Mockito.when((Object)mockStore.getPropertyStore()).thenReturn(Mockito.mock(PropertyStore.class));
        Mockito.when((Object)mockStore.getSchemaStore()).thenReturn(Mockito.mock(SchemaStore.class));
        Mockito.when((Object)mockStore.getRelationshipGroupStore()).thenReturn(Mockito.mock(RelationshipGroupStore.class));
        RecordChangeSet changeSet = new RecordChangeSet(mockStore);
        changeSet.getNodeRecords().create((Object)1L, null).forChangingLinkage();
        changeSet.getPropertyRecords().create((Object)1L, null).forChangingLinkage();
        changeSet.getRelRecords().create((Object)1L, null).forChangingLinkage();
        changeSet.getSchemaRuleChanges().create((Object)1L, null).forChangingLinkage();
        changeSet.getRelGroupRecords().create((Object)1L, (Object)1).forChangingLinkage();
        changeSet.close();
        Assert.assertEquals((long)0L, (long)changeSet.getNodeRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getPropertyRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getRelRecords().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getSchemaRuleChanges().changeSize());
        Assert.assertEquals((long)0L, (long)changeSet.getRelGroupRecords().changeSize());
    }
}

