/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandReaderV1;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;

public class RelationshipGroupCommandTest {
    private NodeStore nodeStore;
    private XaCommandReader commandReader = new PhysicalLogNeoXaCommandReaderV1(ByteBuffer.allocate(64));
    private XaCommandWriter commandWriter = new PhysicalLogNeoXaCommandWriter();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Before
    public void before() throws Exception {
        StoreFactory storeFactory = new StoreFactory(new Config(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
        File storeFile = new File("story");
        storeFactory.createNodeStore(storeFile);
        this.nodeStore = storeFactory.newNodeStore(storeFile);
    }

    @After
    public void after() throws Exception {
        this.nodeStore.close();
    }

    @Test
    public void shouldSerializeAndDeserializeUnusedRecords() throws Exception {
        RelationshipGroupRecord record = new RelationshipGroupRecord(10L, 12);
        record.setInUse(false);
        Command.RelationshipGroupCommand command = new Command.RelationshipGroupCommand();
        command.init(record);
        this.assertSerializationWorksFor(command);
    }

    @Test
    public void shouldSerializeCreatedRecord() throws Exception {
        RelationshipGroupRecord record = new RelationshipGroupRecord(10L, 12);
        record.setCreated();
        record.setInUse(true);
        Command.RelationshipGroupCommand command = new Command.RelationshipGroupCommand();
        command.init(record);
        this.assertSerializationWorksFor(command);
    }

    private void assertSerializationWorksFor(Command.RelationshipGroupCommand cmd) throws IOException {
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        this.commandWriter.write((XaCommand)cmd, (LogBuffer)buffer);
        Command.RelationshipGroupCommand result = (Command.RelationshipGroupCommand)this.commandReader.read((ReadableByteChannel)buffer);
        RelationshipGroupRecord recordBefore = cmd.getRecord();
        RelationshipGroupRecord recordAfter = result.getRecord();
        MatcherAssert.assertThat((Object)recordBefore.getFirstIn(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstIn()));
        MatcherAssert.assertThat((Object)recordBefore.getFirstOut(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstOut()));
        MatcherAssert.assertThat((Object)recordBefore.getFirstLoop(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstLoop()));
        MatcherAssert.assertThat((Object)recordBefore.getNext(), (Matcher)IsEqual.equalTo((Object)recordAfter.getNext()));
        MatcherAssert.assertThat((Object)recordBefore.getOwningNode(), (Matcher)IsEqual.equalTo((Object)recordAfter.getOwningNode()));
        MatcherAssert.assertThat((Object)recordBefore.getPrev(), (Matcher)IsEqual.equalTo((Object)recordAfter.getPrev()));
        MatcherAssert.assertThat((Object)recordBefore.getType(), (Matcher)IsEqual.equalTo((Object)recordAfter.getType()));
    }
}

