/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.RecordSerializable;
import org.neo4j.kernel.impl.nioneo.store.RecordSerializer;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.NeoXaCommandExecutor;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandReaderV1;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class SchemaRuleCommandTest {
    private final NeoStore neoStore = (NeoStore)Mockito.mock(NeoStore.class);
    private final SchemaStore store = (SchemaStore)Mockito.mock(SchemaStore.class);
    private final IndexingService indexes = (IndexingService)Mockito.mock(IndexingService.class);
    private final NeoXaCommandExecutor executor = new NeoXaCommandExecutor(this.neoStore, this.indexes);
    private final PhysicalLogNeoXaCommandReaderV1 reader = new PhysicalLogNeoXaCommandReaderV1(ByteBuffer.allocate(1000));
    private final PhysicalLogNeoXaCommandWriter writer = new PhysicalLogNeoXaCommandWriter();
    private final int labelId = 2;
    private final int propertyKey = 8;
    private final long id = 0L;
    private final long txId = 1337L;
    private final IndexRule rule = IndexRule.indexRule((long)0L, (int)2, (int)8, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);

    @Test
    public void shouldWriteCreatedSchemaRuleToStore() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule, 1337L);
        this.executor.execute((XaCommand)command);
        ((SchemaStore)Mockito.verify((Object)this.store)).updateRecord((DynamicRecord)IteratorUtil.first(afterRecords));
        ((IndexingService)Mockito.verify((Object)this.indexes)).createIndex(this.rule);
    }

    @Test
    public void shouldSetLatestConstraintRule() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, true, false);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)2, (int)8, (long)0L), 1337L);
        this.executor.execute((XaCommand)command);
        ((SchemaStore)Mockito.verify((Object)this.store)).updateRecord((DynamicRecord)IteratorUtil.first(afterRecords));
        ((NeoStore)Mockito.verify((Object)this.neoStore)).setLatestConstraintIntroducingTx(1337L);
    }

    @Test
    public void shouldDropSchemaRuleFromStore() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule, 1337L);
        this.executor.execute((XaCommand)command);
        ((SchemaStore)Mockito.verify((Object)this.store)).updateRecord((DynamicRecord)IteratorUtil.first(afterRecords));
        ((IndexingService)Mockito.verify((Object)this.indexes)).dropIndex(this.rule);
    }

    @Test
    public void shouldWriteSchemaRuleToLog() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule, 1337L);
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        this.writer.write((XaCommand)command, (LogBuffer)buffer);
        XaCommand readCommand = this.reader.read((ReadableByteChannel)buffer);
        Assert.assertThat((Object)readCommand, (Matcher)CoreMatchers.instanceOf(Command.SchemaRuleCommand.class));
        Command.SchemaRuleCommand readSchemaCommand = (Command.SchemaRuleCommand)readCommand;
        Assert.assertThat((Object)readSchemaCommand.getTxId(), (Matcher)Matchers.equalTo((Object)1337L));
    }

    @Test
    public void shouldRecreateSchemaRuleWhenDeleteCommandReadFromDisk() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule, 1337L);
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        this.writer.write((XaCommand)command, (LogBuffer)buffer);
        XaCommand readCommand = this.reader.read((ReadableByteChannel)buffer);
        Assert.assertThat((Object)readCommand, (Matcher)CoreMatchers.instanceOf(Command.SchemaRuleCommand.class));
        Command.SchemaRuleCommand readSchemaCommand = (Command.SchemaRuleCommand)readCommand;
        Assert.assertThat((Object)readSchemaCommand.getTxId(), (Matcher)Matchers.equalTo((Object)1337L));
        Assert.assertThat((Object)readSchemaCommand.getSchemaRule(), (Matcher)Matchers.equalTo((Object)this.rule));
    }

    private Collection<DynamicRecord> serialize(SchemaRule rule, long id, boolean inUse, boolean created) {
        RecordSerializer serializer = new RecordSerializer();
        serializer = serializer.append((RecordSerializable)rule);
        DynamicRecord record = new DynamicRecord(id);
        record.setData(serializer.serialize());
        if (created) {
            record.setCreated();
        }
        if (inUse) {
            record.setInUse(true);
        }
        return Arrays.asList(record);
    }
}

