/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.xa.IntegrityValidator;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionTest;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;

public class WriteTransactionCommandOrderingTest {
    private final AtomicReference<List<String>> currentRecording = new AtomicReference();
    private final NeoStore store = (NeoStore)Mockito.mock(NeoStore.class);
    private final RecordingRelationshipStore relationshipStore = new RecordingRelationshipStore(this.currentRecording);
    private final RecordingNodeStore nodeStore = new RecordingNodeStore(this.currentRecording);
    private final RecordingPropertyStore propertyStore = new RecordingPropertyStore(this.currentRecording);

    public WriteTransactionCommandOrderingTest() {
        Mockito.when((Object)this.store.getPropertyStore()).thenReturn((Object)this.propertyStore);
        Mockito.when((Object)this.store.getNodeStore()).thenReturn((Object)this.nodeStore);
        Mockito.when((Object)this.store.getRelationshipStore()).thenReturn((Object)this.relationshipStore);
    }

    @Test
    public void shouldExecuteCommandsInTheSameOrderRegardlessOfItBeingRecoveredOrNot() throws Exception {
        ArrayList nonRecoveredRecording = new ArrayList();
        NeoStoreTransaction nonRecoveredTx = this.newWriteTransaction();
        this.injectAllPossibleCommands(nonRecoveredTx);
        ArrayList recoveredRecording = new ArrayList();
        NeoStoreTransaction recoveredTx = this.newWriteTransaction();
        recoveredTx.setRecovered();
        this.injectAllPossibleCommands(recoveredTx);
        this.currentRecording.set(nonRecoveredRecording);
        nonRecoveredTx.doPrepare();
        nonRecoveredTx.doCommit();
        this.currentRecording.set(recoveredRecording);
        recoveredTx.doPrepare();
        recoveredTx.doCommit();
        Assert.assertThat(nonRecoveredRecording, (Matcher)Matchers.equalTo(recoveredRecording));
        Assert.assertThat((Object)new HashSet(recoveredRecording).size(), (Matcher)Matchers.is((Object)9));
    }

    private void injectAllPossibleCommands(NeoStoreTransaction tx) {
        Command.NodeCommand updatedNode = new Command.NodeCommand();
        updatedNode.init(WriteTransactionCommandOrderingTest.inUseNode(), WriteTransactionCommandOrderingTest.inUseNode());
        tx.injectCommand((XaCommand)updatedNode);
        Command.NodeCommand deletedNode = new Command.NodeCommand();
        deletedNode.init(WriteTransactionCommandOrderingTest.inUseNode(), WriteTransactionCommandOrderingTest.missingNode());
        tx.injectCommand((XaCommand)deletedNode);
        Command.NodeCommand createdNode = new Command.NodeCommand();
        createdNode.init(WriteTransactionCommandOrderingTest.missingNode(), WriteTransactionCommandOrderingTest.createdNode());
        tx.injectCommand((XaCommand)createdNode);
        Command.PropertyCommand updatedProp = new Command.PropertyCommand();
        updatedProp.init(WriteTransactionCommandOrderingTest.inUseProperty(), WriteTransactionCommandOrderingTest.inUseProperty());
        tx.injectCommand((XaCommand)updatedProp);
        Command.PropertyCommand deletedProp = new Command.PropertyCommand();
        deletedProp.init(WriteTransactionCommandOrderingTest.inUseProperty(), WriteTransactionCommandOrderingTest.missingProperty());
        tx.injectCommand((XaCommand)deletedProp);
        Command.PropertyCommand createdProp = new Command.PropertyCommand();
        createdProp.init(WriteTransactionCommandOrderingTest.missingProperty(), WriteTransactionCommandOrderingTest.createdProperty());
        tx.injectCommand((XaCommand)createdProp);
        Command.RelationshipCommand updatedRel = new Command.RelationshipCommand();
        updatedRel.init(WriteTransactionCommandOrderingTest.inUseRelationship());
        tx.injectCommand((XaCommand)updatedRel);
        Command.RelationshipCommand deletedRel = new Command.RelationshipCommand();
        deletedRel.init(WriteTransactionCommandOrderingTest.missingRelationship());
        tx.injectCommand((XaCommand)deletedRel);
        Command.RelationshipCommand createdRel = new Command.RelationshipCommand();
        createdRel.init(WriteTransactionCommandOrderingTest.createdRelationship());
        tx.injectCommand((XaCommand)createdRel);
    }

    private static RelationshipRecord missingRelationship() {
        return new RelationshipRecord(-1L);
    }

    private static RelationshipRecord createdRelationship() {
        RelationshipRecord record = new RelationshipRecord(2L);
        record.setInUse(true);
        record.setCreated();
        return record;
    }

    private static RelationshipRecord inUseRelationship() {
        RelationshipRecord record = new RelationshipRecord(1L);
        record.setInUse(true);
        return record;
    }

    private static PropertyRecord missingProperty() {
        return new PropertyRecord(-1L);
    }

    private static PropertyRecord createdProperty() {
        PropertyRecord record = new PropertyRecord(2L);
        record.setInUse(true);
        record.setCreated();
        return record;
    }

    private static PropertyRecord inUseProperty() {
        PropertyRecord record = new PropertyRecord(1L);
        record.setInUse(true);
        return record;
    }

    private static NodeRecord missingNode() {
        return new NodeRecord(-1L, false, -1L, -1L);
    }

    private static NodeRecord createdNode() {
        NodeRecord record = new NodeRecord(2L, false, -1L, -1L);
        record.setInUse(true);
        record.setCreated();
        return record;
    }

    private static NodeRecord inUseNode() {
        NodeRecord record = new NodeRecord(1L, false, -1L, -1L);
        record.setInUse(true);
        return record;
    }

    private NeoStoreTransaction newWriteTransaction() {
        NeoStoreTransactionContext context = new NeoStoreTransactionContext((NeoStoreTransactionContextSupplier)Mockito.mock(NeoStoreTransactionContextSupplier.class), this.store);
        context.bind(TransactionState.NO_STATE);
        NeoStoreTransaction tx = new NeoStoreTransaction(0L, (XaLogicalLog)Mockito.mock(XaLogicalLog.class), this.store, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), (IndexingService)Mockito.mock(IndexingService.class), NeoStoreTransactionTest.NO_LABEL_SCAN_STORE, (IntegrityValidator)Mockito.mock(IntegrityValidator.class), (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class), (LockService)Mockito.mock(LockService.class, (Answer)Mockito.RETURNS_MOCKS), context);
        tx.setCommitTxId(this.store.getLastCommittedTx() + 1L);
        return tx;
    }

    private static String commandActionToken(AbstractBaseRecord record) {
        if (!record.inUse()) {
            return "deleted";
        }
        if (record.isCreated()) {
            return "created";
        }
        return "updated";
    }

    private static class RecordingRelationshipStore
    extends RelationshipStore {
        private final AtomicReference<List<String>> currentRecording;

        public RecordingRelationshipStore(AtomicReference<List<String>> currentRecording) {
            super(null, null, null, null, null, null, null);
            this.currentRecording = currentRecording;
        }

        public void updateRecord(RelationshipRecord record) {
            this.currentRecording.get().add(WriteTransactionCommandOrderingTest.commandActionToken((AbstractBaseRecord)record) + " relationship");
        }

        protected void checkStorage() {
        }

        protected void checkVersion() {
        }

        protected void loadStorage() {
        }
    }

    private static class RecordingNodeStore
    extends NodeStore {
        private final AtomicReference<List<String>> currentRecording;

        public RecordingNodeStore(AtomicReference<List<String>> currentRecording) {
            super(null, null, null, null, null, null, null, null);
            this.currentRecording = currentRecording;
        }

        public void updateRecord(NodeRecord record) {
            this.currentRecording.get().add(WriteTransactionCommandOrderingTest.commandActionToken((AbstractBaseRecord)record) + " node");
        }

        protected void checkStorage() {
        }

        protected void checkVersion() {
        }

        protected void loadStorage() {
        }

        public NodeRecord getRecord(long id) {
            NodeRecord record = new NodeRecord(id, false, -1L, -1L);
            record.setInUse(true);
            return record;
        }
    }

    private static class RecordingPropertyStore
    extends PropertyStore {
        private final AtomicReference<List<String>> currentRecording;

        public RecordingPropertyStore(AtomicReference<List<String>> currentRecording) {
            super(null, null, null, null, null, null, null, null, null, null);
            this.currentRecording = currentRecording;
        }

        public void updateRecord(PropertyRecord record) {
            this.currentRecording.get().add(WriteTransactionCommandOrderingTest.commandActionToken((AbstractBaseRecord)record) + " property");
        }

        protected void checkStorage() {
        }

        protected void checkVersion() {
        }

        protected void loadStorage() {
        }
    }
}

