/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandReaderV0;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandReaderV1;

public class XaCommandReaderFactoryTest {
    @Test
    public void testReturnsV0ReaderForVersion0() throws Exception {
        XaCommandReaderFactory factory = XaCommandReaderFactory.DEFAULT;
        XaCommandReader reader = factory.newInstance((byte)0, (ByteBuffer)Mockito.mock(ByteBuffer.class));
        Assert.assertTrue((boolean)(reader instanceof PhysicalLogNeoXaCommandReaderV0));
    }

    @Test
    public void testReturnsV1ReaderForVersion1() throws Exception {
        XaCommandReaderFactory factory = XaCommandReaderFactory.DEFAULT;
        XaCommandReader reader = factory.newInstance((byte)-1, (ByteBuffer)Mockito.mock(ByteBuffer.class));
        Assert.assertTrue((boolean)(reader instanceof PhysicalLogNeoXaCommandReaderV1));
    }

    @Test
    public void testThrowsExceptionForNonExistingVersion() throws Exception {
        XaCommandReaderFactory factory = XaCommandReaderFactory.DEFAULT;
        try {
            factory.newInstance((byte)-5, (ByteBuffer)Mockito.mock(ByteBuffer.class));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

