/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.xaframework.LogMatchers;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class KernelRecoveryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Test
    public void shouldHandleWritesProperlyAfterRecovery() throws Exception {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        GraphDatabaseService db = this.newDB(fs);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        db.shutdown();
        db = this.newDB(crashedFs);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
        MatcherAssert.assertThat(LogMatchers.logEntries((FileSystemAbstraction)crashedFs, new File("target/test-data/impermanent-db/nioneo_logical.log.v0")), LogMatchers.containsExactly(LogMatchers.startEntry(3, -1, -1), LogMatchers.commandEntry(3), LogMatchers.onePhaseCommitEntry(3, 2), LogMatchers.doneEntry(3), LogMatchers.startEntry(6, -1, -1), LogMatchers.commandEntry(6), LogMatchers.onePhaseCommitEntry(6, 3), LogMatchers.doneEntry(6)));
    }

    private GraphDatabaseService newDB(EphemeralFileSystemAbstraction fs) {
        return new TestGraphDatabaseFactory().setFileSystem(fs).newImpermanentDatabase();
    }
}

