/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestStoreRecoverer {
    private final EphemeralFileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();

    @Test
    public void shouldNotWantToRecoverIntactStore() throws Exception {
        File store = null;
        store = this.createIntactStore();
        StoreRecoverer recoverer = new StoreRecoverer((FileSystemAbstraction)this.fileSystem);
        Assert.assertThat((Object)recoverer.recoveryNeededAt(store, new HashMap()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldWantToRecoverBrokenStore() throws Exception {
        File store = this.createIntactStore();
        this.fileSystem.deleteFile(new File(store, "nioneo_logical.log.active"));
        StoreRecoverer recoverer = new StoreRecoverer((FileSystemAbstraction)this.fileSystem);
        Assert.assertThat((Object)recoverer.recoveryNeededAt(store, new HashMap()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldBeAbleToRecoverBrokenStore() throws Exception {
        File store = this.createIntactStore();
        this.fileSystem.deleteFile(new File(store, "nioneo_logical.log.active"));
        StoreRecoverer recoverer = new StoreRecoverer((FileSystemAbstraction)this.fileSystem);
        Assert.assertThat((Object)recoverer.recoveryNeededAt(store, new HashMap()), (Matcher)CoreMatchers.is((Object)true));
        new TestGraphDatabaseFactory().setFileSystem(this.fileSystem).newImpermanentDatabase(store.getPath()).shutdown();
        Assert.assertThat((Object)recoverer.recoveryNeededAt(store, new HashMap()), (Matcher)CoreMatchers.is((Object)false));
    }

    private File createIntactStore() throws IOException {
        File storeDir = new File("dir");
        new TestGraphDatabaseFactory().setFileSystem(this.fileSystem).newImpermanentDatabase(storeDir.getPath()).shutdown();
        return storeDir;
    }
}

