/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.storemigration.CurrentDatabase;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class CurrentDatabaseTest {
    @Test
    public void shouldRejectStoreWhereOneFileHasTheWrongVersion() throws Exception {
        File workingDirectory = new File("target/" + CurrentDatabaseTest.class.getSimpleName());
        StoreVersionCheck storeVersionCheck = (StoreVersionCheck)Mockito.mock(StoreVersionCheck.class);
        File neoStoreDb = new File(workingDirectory, "neostore.nodestore.db");
        Mockito.when((Object)storeVersionCheck.hasVersion((File)Matchers.eq((Object)neoStoreDb), Matchers.anyString())).thenReturn((Object)Pair.of((Object)StoreVersionCheck.Outcome.missingStoreFile, null));
        Mockito.when((Object)storeVersionCheck.hasVersion((File)AdditionalMatchers.not((Object)Matchers.eq((Object)neoStoreDb)), Matchers.anyString())).thenReturn((Object)Pair.of((Object)StoreVersionCheck.Outcome.ok, null));
        Assert.assertFalse((boolean)new CurrentDatabase(storeVersionCheck).storeFilesAtCurrentVersion(workingDirectory));
    }

    @Test
    public void shouldAcceptStoreWhenAllFilesHaveTheCorrectVersion() {
        File workingDirectory = new File("target/" + CurrentDatabaseTest.class.getSimpleName());
        StoreVersionCheck storeVersionCheck = (StoreVersionCheck)Mockito.mock(StoreVersionCheck.class);
        Mockito.when((Object)storeVersionCheck.hasVersion((File)Matchers.any(File.class), Matchers.anyString())).thenReturn((Object)Pair.of((Object)StoreVersionCheck.Outcome.ok, null));
        TestCase.assertTrue((boolean)new CurrentDatabase(storeVersionCheck).storeFilesAtCurrentVersion(workingDirectory));
    }
}

