/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import org.junit.Assert;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.StoreFile20;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.test.Unzip;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class MigrationTestUtils {
    public static Config defaultConfig() {
        return MigrationTestUtils.defaultConfig(MapUtil.stringMap((String[])new String[0]));
    }

    public static Config defaultConfig(Map<String, String> inputParams) {
        return new Config(inputParams, new Class[]{GraphDatabaseSettings.class});
    }

    public static int[] makeLongArray() {
        int[] longArray = new int[100];
        for (int i = 0; i < 100; ++i) {
            longArray[i] = i;
        }
        return longArray;
    }

    public static String makeLongString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append("characters");
        }
        return builder.toString();
    }

    public static void changeVersionNumber(FileSystemAbstraction fileSystem, File storeFile, String versionString) throws IOException {
        byte[] versionBytes = UTF8.encode((String)versionString);
        StoreChannel fileChannel = fileSystem.open(storeFile, "rw");
        fileChannel.position(fileSystem.getFileSize(storeFile) - (long)versionBytes.length);
        fileChannel.write(ByteBuffer.wrap(versionBytes));
        fileChannel.close();
    }

    public static void truncateFile(FileSystemAbstraction fileSystem, File storeFile, String suffixToDetermineTruncationLength) throws IOException {
        byte[] versionBytes = UTF8.encode((String)suffixToDetermineTruncationLength);
        StoreChannel fileChannel = fileSystem.open(storeFile, "rw");
        fileChannel.truncate(fileSystem.getFileSize(storeFile) - (long)versionBytes.length);
        fileChannel.close();
    }

    public static void truncateAllFiles(FileSystemAbstraction fileSystem, File workingDirectory) throws IOException {
        for (StoreFile20 storeFile : StoreFile20.legacyStoreFiles()) {
            MigrationTestUtils.truncateFile(fileSystem, new File(workingDirectory, storeFile.storeFileName()), storeFile.legacyVersion());
        }
    }

    public static void truncateToFixedLength(FileSystemAbstraction fileSystem, File storeFile, int newLength) throws IOException {
        StoreChannel fileChannel = fileSystem.open(storeFile, "rw");
        fileChannel.truncate((long)newLength);
        fileChannel.close();
    }

    public static void prepareSampleLegacyDatabase(EphemeralFileSystemAbstraction workingFs, File workingDirectory) throws IOException {
        File resourceDirectory = MigrationTestUtils.find20FormatStoreDirectory();
        workingFs.copyRecursivelyFromOtherFs(resourceDirectory, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), workingDirectory);
    }

    public static void prepareSampleLegacyDatabase(FileSystemAbstraction workingFs, File workingDirectory) throws IOException {
        File resourceDirectory = MigrationTestUtils.find20FormatStoreDirectory();
        workingFs.deleteRecursively(workingDirectory);
        workingFs.mkdirs(workingDirectory);
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
    }

    public static File find20FormatStoreDirectory() throws IOException {
        return Unzip.unzip(Legacy20Store.class, "exampledb.zip");
    }

    public static File find19FormatStoreDirectory(File unzipTarget) throws IOException {
        return Unzip.unzip(Legacy19Store.class, "upgradeTest19Db.zip", unzipTarget);
    }

    public static File find20FormatStoreDirectory(File unzipTarget) throws IOException {
        return Unzip.unzip(Legacy20Store.class, "exampledb.zip", unzipTarget);
    }

    public static boolean allStoreFilesHaveVersion(FileSystemAbstraction fileSystem, File workingDirectory, String version) throws IOException {
        for (StoreFile20 storeFile : StoreFile20.legacyStoreFiles()) {
            StoreChannel channel = fileSystem.open(new File(workingDirectory, storeFile.storeFileName()), "r");
            int length = UTF8.encode((String)version).length;
            byte[] bytes = new byte[length];
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            channel.position(channel.size() - (long)length);
            channel.read(buffer);
            channel.close();
            String foundVersion = UTF8.decode((byte[])bytes);
            if (version.equals(foundVersion)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAnyStoreFiles(FileSystemAbstraction fileSystem, File directory) {
        for (StoreFile20 file : StoreFile20.values()) {
            if (!fileSystem.fileExists(new File(directory, file.storeFileName()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyFilesHaveSameContent(FileSystemAbstraction fileSystem, File original, File other) throws IOException {
        block3: for (File originalFile : fileSystem.listFiles(original)) {
            File otherFile = new File(other, originalFile.getName());
            if (fileSystem.isDirectory(originalFile)) continue;
            StoreChannel originalChannel = fileSystem.open(originalFile, "r");
            StoreChannel otherChannel = fileSystem.open(otherFile, "r");
            try {
                ByteBuffer buffer = ByteBuffer.allocate(1);
                while (true) {
                    if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)originalChannel, (ByteBuffer)buffer, (int)1)) {
                        continue block3;
                    }
                    byte originalByte = buffer.get();
                    if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)otherChannel, (ByteBuffer)buffer, (int)1)) {
                        Assert.fail((String)"Files have different sizes");
                    }
                    Assert.assertEquals((String)("Different content in " + originalFile.getName()), (long)originalByte, (long)buffer.get());
                }
            }
            finally {
                originalChannel.close();
                otherChannel.close();
            }
        }
    }

    public static File isolatedMigrationDirectoryOf(File dbDirectory) {
        return new File(dbDirectory, "upgrade");
    }
}

