/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class StoreVersionCheckTest {
    @Test
    public void shouldReportMissingFileDoesNotHaveSpecifiedVersion() {
        File missingFile = new File("/you/will/never/find/me");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck((FileSystemAbstraction)new EphemeralFileSystemAbstraction());
        Assert.assertFalse((boolean)((StoreVersionCheck.Outcome)storeVersionCheck.hasVersion(missingFile, "version").first()).isSuccessful());
    }

    @Test
    public void shouldReportShortFileDoesNotHaveSpecifiedVersion() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        File shortFile = this.fileContaining(fs, "a");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck((FileSystemAbstraction)fs);
        Assert.assertFalse((boolean)((StoreVersionCheck.Outcome)storeVersionCheck.hasVersion(shortFile, "version").first()).isSuccessful());
    }

    @Test
    public void shouldReportFileWithIncorrectVersion() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        File shortFile = this.fileContaining(fs, "versionWhichIsIncorrect");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck((FileSystemAbstraction)fs);
        Assert.assertFalse((boolean)((StoreVersionCheck.Outcome)storeVersionCheck.hasVersion(shortFile, "correctVersion 1").first()).isSuccessful());
    }

    @Test
    public void shouldReportFileWithCorrectVersion() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        File shortFile = this.fileContaining(fs, "correctVersion 1");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck((FileSystemAbstraction)fs);
        Assert.assertTrue((boolean)((StoreVersionCheck.Outcome)storeVersionCheck.hasVersion(shortFile, "correctVersion 1").first()).isSuccessful());
    }

    private File fileContaining(EphemeralFileSystemAbstraction fs, String content) throws IOException {
        File shortFile = new File("shortFile");
        OutputStream outputStream = fs.openAsOutputStream(shortFile, true);
        outputStream.write(content.getBytes());
        outputStream.close();
        return shortFile;
    }
}

