/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;

public class UpgradableDatabaseTest {
    private final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
    private File workingDirectory;

    @Test
    public void shouldAcceptTheStoresInTheSampleDatabaseAsBeingEligibleForUpgrade() {
        Assert.assertTrue((boolean)new UpgradableDatabase(new StoreVersionCheck(this.fileSystem)).storeFilesUpgradeable(this.workingDirectory));
    }

    @Test
    public void shouldRejectStoresIfOneFileHasIncorrectVersion() throws IOException {
        MigrationTestUtils.changeVersionNumber(this.fileSystem, new File(this.workingDirectory, "neostore.nodestore.db"), "v0.9.5");
        Assert.assertFalse((boolean)new UpgradableDatabase(new StoreVersionCheck(this.fileSystem)).storeFilesUpgradeable(this.workingDirectory));
    }

    @Test
    public void shouldRejectStoresIfOneFileHasNoVersionAsIfNotShutDownCleanly() throws IOException {
        MigrationTestUtils.truncateFile(this.fileSystem, new File(this.workingDirectory, "neostore.nodestore.db"), "StringPropertyStore v0.A.1");
        Assert.assertFalse((boolean)new UpgradableDatabase(new StoreVersionCheck(this.fileSystem)).storeFilesUpgradeable(this.workingDirectory));
    }

    @Test
    public void shouldRejectStoresIfOneFileShorterThanExpectedVersionString() throws IOException {
        int shortFileLength = 15;
        Assert.assertTrue((shortFileLength < UTF8.encode((String)"StringPropertyStore v0.A.1").length ? 1 : 0) != 0);
        MigrationTestUtils.truncateToFixedLength(this.fileSystem, new File(this.workingDirectory, "neostore.relationshiptypestore.db"), shortFileLength);
        Assert.assertFalse((boolean)new UpgradableDatabase(new StoreVersionCheck(this.fileSystem)).storeFilesUpgradeable(this.workingDirectory));
    }

    @Test
    @Ignore(value="Pending fix")
    public void shouldCommunicateWhatCausesInabilityToUpgrade() throws IOException {
        MigrationTestUtils.changeVersionNumber(this.fileSystem, new File(this.workingDirectory, "neostore.nodestore.db"), "v0.9.5");
        try {
            new UpgradableDatabase(new StoreVersionCheck(this.fileSystem)).checkUpgradeable(this.workingDirectory);
            Assert.fail((String)"should not have been able to upgrade");
        }
        catch (StoreUpgrader.UnexpectedUpgradingStoreVersionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"'neostore.nodestore.db' has a store version number that we cannot upgrade from. Expected 'NodeStore v0.A.1' but file is version 'NodeStore v0.9.5'."));
        }
    }

    @Before
    public void prepareDirectory() throws IOException {
        this.workingDirectory = MigrationTestUtils.find20FormatStoreDirectory();
    }
}

