/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v20;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20NodeStoreReader;
import org.neo4j.test.Unzip;

public class ReadRecordsTestIT {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();

    @Test
    public void shouldReadNodeRecords() throws IOException {
        File storeDir = Unzip.unzip(this.getClass(), "exampledb.zip");
        Legacy20NodeStoreReader nodeStoreReader = new Legacy20NodeStoreReader(this.fs, new File(storeDir, "neostore.nodestore.db"));
        Assert.assertEquals((long)1003L, (long)nodeStoreReader.getMaxId());
        final AtomicInteger nodeCount = new AtomicInteger(0);
        nodeStoreReader.accept(new LegacyNodeStoreReader.Visitor(){

            public void visit(NodeRecord record) {
                if (record.inUse()) {
                    nodeCount.incrementAndGet();
                }
            }
        });
        Assert.assertEquals((long)501L, (long)nodeCount.get());
        nodeStoreReader.close();
    }

    private File exampleDbStore(String fileName) throws IOException {
        return new File(this.exampleDbStore(), fileName);
    }

    private File exampleDbStore() throws IOException {
        return MigrationTestUtils.find20FormatStoreDirectory();
    }
}

