/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnectionHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;

public class DummyXaDataSource
extends XaDataSource {
    private XaContainer xaContainer = null;

    public DummyXaDataSource(byte[] branchId, String name, XaFactory xaFactory, TransactionStateFactory stateFactory, File logFile) throws InstantiationException {
        super(branchId, name);
        try {
            this.xaContainer = xaFactory.newXaContainer((XaDataSource)this, logFile, (XaCommandReaderFactory)new DummyCommandReaderFactory(), (XaCommandWriterFactory)new DummyCommandWriterFactory(), InjectedTransactionValidator.ALLOW_ALL, (XaTransactionFactory)new DummyTransactionFactory(), stateFactory, new TransactionInterceptorProviders(Iterables.empty(), (DependencyResolver)new DependencyResolver.Adapter(){

                public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
                    return type.cast(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.intercept_committing_transactions.name(), "false", GraphDatabaseSettings.intercept_deserialized_transactions.name(), "false"})));
                }
            }), false, Functions.identity());
            this.xaContainer.openLogicalLog();
        }
        catch (IOException e) {
            throw new InstantiationException("" + e);
        }
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
        this.xaContainer.close();
    }

    public void shutdown() {
    }

    public XaConnection getXaConnection() {
        return new DummyXaConnection(this.xaContainer.getResourceManager());
    }

    public long getLastCommittedTxId() {
        return 0L;
    }

    static class DummyTransactionFactory
    extends XaTransactionFactory {
        DummyTransactionFactory() {
        }

        public XaTransaction create(long lastCommittedTxWhenTransactionStarted, TransactionState state) {
            return new DummyTransaction(this.getLogicalLog(), state);
        }

        public void flushAll() {
        }

        public long getAndSetNewVersion() {
            return 0L;
        }

        public long getCurrentVersion() {
            return 0L;
        }

        public void setVersion(long version) {
        }

        public long getLastCommittedTx() {
            return 0L;
        }
    }

    private static class DummyTransaction
    extends XaTransaction {
        private final List<XaCommand> commandList = new ArrayList<XaCommand>();

        public DummyTransaction(XaLogicalLog log, TransactionState state) {
            super(log, state);
            this.setCommitTxId(0L);
        }

        public void doAddCommand(XaCommand command) {
            this.commandList.add(command);
        }

        public void doPrepare() {
        }

        public void doRollback() {
        }

        public void doCommit() {
        }

        public boolean isReadOnly() {
            return false;
        }
    }

    private static class DummyCommandWriterFactory
    implements XaCommandWriterFactory {
        private DummyCommandWriterFactory() {
        }

        public XaCommandWriter newInstance() {
            return new XaCommandWriter(){

                public void write(XaCommand command, LogBuffer buffer) throws IOException {
                    buffer.putInt(((DummyCommand)command).getType());
                }
            };
        }
    }

    private static class DummyCommandReaderFactory
    implements XaCommandReaderFactory {
        private DummyCommandReaderFactory() {
        }

        public XaCommandReader newInstance(byte logEntryVersion, final ByteBuffer buffer) {
            return new XaCommandReader(){

                public XaCommand read(ReadableByteChannel channel) throws IOException {
                    buffer.clear();
                    buffer.limit(4);
                    if (channel.read(buffer) == 4) {
                        buffer.flip();
                        return new DummyCommand(buffer.getInt());
                    }
                    return null;
                }
            };
        }
    }

    private static class DummyCommand
    extends XaCommand {
        private int type = -1;

        DummyCommand(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    static class DummyXaConnection
    extends XaConnectionHelpImpl {
        private XAResource xaResource = null;

        public DummyXaConnection(XaResourceManager xaRm) {
            super(xaRm);
            this.xaResource = new DummyXaResource(xaRm);
        }

        public XAResource getXaResource() {
            return this.xaResource;
        }

        public void doStuff1() throws XAException {
            this.validate();
            this.getTransaction().addCommand((XaCommand)new DummyCommand(1));
        }

        public void doStuff2() throws XAException {
            this.validate();
            this.getTransaction().addCommand((XaCommand)new DummyCommand(2));
        }

        public void enlistWithTx(TransactionManager tm) throws Exception {
            tm.getTransaction().enlistResource(this.xaResource);
        }

        public void delistFromTx(TransactionManager tm) throws Exception {
            tm.getTransaction().delistResource(this.xaResource, 0x4000000);
        }

        public int getTransactionId() throws Exception {
            return this.getTransaction().getIdentifier();
        }
    }

    static class DummyXaResource
    extends XaResourceHelpImpl {
        DummyXaResource(XaResourceManager xaRm) {
            super(xaRm, null);
        }

        public boolean isSameRM(XAResource resource) {
            return resource instanceof DummyXaResource;
        }
    }
}

