/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.OtherThreadExecutor;

public class ExternalTransactionControlIT {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void shouldAllowSuspendingAndResumingTransactions() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        TransactionManager tm = (TransactionManager)db.getDependencyResolver().resolveDependency(TransactionManager.class);
        Node node = this.createNode();
        try (org.neo4j.graphdb.Transaction ignored = db.beginTx();){
            node.addLabel((Label)Labels.MY_LABEL);
            Transaction jtaTx = tm.suspend();
            Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not(Neo4jMatchers.hasLabel(Labels.MY_LABEL))));
            tm.resume(jtaTx);
            Assert.assertTrue((String)"The label should be visible when I've resumed the transaction.", (boolean)node.hasLabel((Label)Labels.MY_LABEL));
        }
    }

    @Test
    public void shouldBeAbleToUseJTATransactionManagerForTxManagement() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        TransactionManager tm = (TransactionManager)db.getDependencyResolver().resolveDependency(TransactionManager.class);
        tm.begin();
        Node node = db.createNode();
        node.addLabel((Label)Labels.MY_LABEL);
        tm.commit();
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasLabel(Labels.MY_LABEL)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToMoveTransactionToAnotherThread() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        final TransactionManager tm = (TransactionManager)db.getDependencyResolver().resolveDependency(TransactionManager.class);
        final Node node = this.createNode();
        try (org.neo4j.graphdb.Transaction ignored = db.beginTx();){
            boolean result;
            node.addLabel((Label)Labels.MY_LABEL);
            final Transaction jtaTx = tm.suspend();
            try {
                OtherThreadExecutor<Object> otherThread = new OtherThreadExecutor<Object>("Thread to resume tx in", null);
                result = otherThread.execute(new OtherThreadExecutor.WorkerCommand<Boolean, Boolean>(){

                    @Override
                    public Boolean doWork(Boolean ignore) {
                        try {
                            tm.resume(jtaTx);
                            Boolean bl = node.hasLabel((Label)Labels.MY_LABEL);
                            return bl;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            try {
                                tm.suspend();
                            }
                            catch (SystemException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                });
            }
            finally {
                tm.resume(jtaTx);
            }
            Assert.assertTrue((String)"The label should be visible when I've resumed the transaction.", (boolean)result);
        }
    }

    private Node createNode() {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
            Node node = db.createNode();
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private static enum Labels implements Label
    {
        MY_LABEL;

    }
}

