/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.LogTestUtils;

public class ReadTransactionLogWritingTest {
    @Rule
    public final DatabaseRule dbr = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.cache_type, "none");
        }
    };
    private final Label label = DynamicLabel.label((String)"Test");
    private Node node;
    private Relationship relationship;
    private int logEntriesWrittenBeforeReadOperations;

    @Test
    public void shouldNotWriteAnyLogCommandInPureReadTransaction() throws Exception {
        this.executeTransaction(this.getRelationships());
        this.executeTransaction(this.getProperties());
        this.executeTransaction(this.getById());
        this.executeTransaction(this.getNodesFromRelationship());
        int actualCount = this.countLogEntries();
        Assert.assertEquals((String)("There were " + (actualCount - this.logEntriesWrittenBeforeReadOperations) + " log entries written during one or more pure read transactions"), (long)this.logEntriesWrittenBeforeReadOperations, (long)actualCount);
    }

    @Before
    public void createDataset() {
        GraphDatabaseAPI db = this.dbr.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            this.node = db.createNode(new Label[]{this.label});
            this.node.setProperty("short", (Object)123);
            this.node.setProperty("long", (Object)this.longString(300));
            long nodeId = this.node.getId();
            this.relationship = this.node.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            this.relationship.setProperty("short", (Object)123);
            this.relationship.setProperty("long", (Object)this.longString(300));
            long relationshipId = this.relationship.getId();
            tx.success();
        }
        ((XaDataSourceManager)db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).rotateLogicalLogs();
        this.logEntriesWrittenBeforeReadOperations = this.countLogEntries();
    }

    private int countLogEntries() {
        GraphDatabaseAPI db = this.dbr.getGraphDatabaseAPI();
        FileSystemAbstraction fs = (FileSystemAbstraction)db.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
        File storeDir = new File(db.getStoreDir());
        try {
            LogTestUtils.CountingLogHook<LogEntry> logicalLogCounter = new LogTestUtils.CountingLogHook<LogEntry>();
            LogTestUtils.filterNeostoreLogicalLog(fs, storeDir.getPath(), logicalLogCounter);
            int txLogRecordCount = ((TxManager)db.getDependencyResolver().resolveDependency(TxManager.class)).getTxLog().getRecordCount();
            return logicalLogCounter.getCount() + txLogRecordCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String longString(int length) {
        char[] characters = new char[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = (char)(97 + i % 10);
        }
        return new String(characters);
    }

    private void executeTransaction(Runnable runnable) {
        this.executeTransaction(runnable, true);
        this.executeTransaction(runnable, false);
    }

    private void executeTransaction(Runnable runnable, boolean success) {
        try (Transaction tx = this.dbr.getGraphDatabaseService().beginTx();){
            runnable.run();
            if (success) {
                tx.success();
            }
        }
    }

    private Runnable getRelationships() {
        return new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)ReadTransactionLogWritingTest.this.node.getRelationships()));
            }
        };
    }

    private Runnable getNodesFromRelationship() {
        return new Runnable(){

            @Override
            public void run() {
                ReadTransactionLogWritingTest.this.relationship.getEndNode();
                ReadTransactionLogWritingTest.this.relationship.getStartNode();
                ReadTransactionLogWritingTest.this.relationship.getNodes();
                ReadTransactionLogWritingTest.this.relationship.getOtherNode(ReadTransactionLogWritingTest.this.node);
            }
        };
    }

    private Runnable getById() {
        return new Runnable(){

            @Override
            public void run() {
                ReadTransactionLogWritingTest.this.dbr.getGraphDatabaseService().getNodeById(ReadTransactionLogWritingTest.this.node.getId());
                ReadTransactionLogWritingTest.this.dbr.getGraphDatabaseService().getRelationshipById(ReadTransactionLogWritingTest.this.relationship.getId());
            }
        };
    }

    private Runnable getProperties() {
        return new Runnable(){

            @Override
            public void run() {
                this.getAllProperties((PropertyContainer)ReadTransactionLogWritingTest.this.node);
                this.getAllProperties((PropertyContainer)ReadTransactionLogWritingTest.this.relationship);
            }

            private void getAllProperties(PropertyContainer entity) {
                for (String key : entity.getPropertyKeys()) {
                    entity.getProperty(key);
                }
            }
        };
    }
}

