/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.SpringTransactionManager;
import org.neo4j.test.TestGraphDatabaseFactory;

public class SpringTransactionManagerTest {
    @Test(timeout=5000L)
    public void testDoubleUpdateWithJavaTM() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        SpringTransactionManager tm = new SpringTransactionManager(db);
        tm.begin();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Foo");
        tm.commit();
        Transaction transaction = db.beginTx();
        Assert.assertEquals((Object)"Foo", (Object)db.getNodeById(node.getId()).getProperty("name"));
        node.setProperty("name", (Object)"Bar");
        transaction.success();
        transaction.finish();
        tm.begin();
        node.setProperty("name", (Object)"FooBar");
        Assert.assertEquals((Object)"FooBar", (Object)db.getNodeById(node.getId()).getProperty("name"));
        tm.commit();
    }
}

