/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.FakeXAResource;
import org.neo4j.kernel.impl.transaction.OtherDummyXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.LogTestUtils;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestInjectMultipleStartEntries {
    private final String storeDir = "dir";
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void fail_prepare_two_phase_transaction_should_not_yield_two_start_log_entries() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase("dir");
        XaDataSourceManager xaDs = (XaDataSourceManager)db.getDependencyResolver().resolveDependency(XaDataSourceManager.class);
        OtherDummyXaDataSource additionalDs = new OtherDummyXaDataSource("dummy", "dummy".getBytes(), new FakeXAResource("dummy"));
        xaDs.registerDataSource((XaDataSource)additionalDs);
        Node node = this.createNodeWithOneRelationshipToIt((GraphDatabaseService)db);
        this.deleteNodeButNotItsRelationshipsInATwoPhaseTransaction(db, additionalDs, node);
        db.shutdown();
        LogTestUtils.filterNeostoreLogicalLog((FileSystemAbstraction)this.fs.get(), new File("dir", "nioneo_logical.log.v0"), (LogTestUtils.LogHook<LogEntry>)new VerificationLogHook());
    }

    private void deleteNodeButNotItsRelationshipsInATwoPhaseTransaction(GraphDatabaseAPI db, XaDataSource additionalDs, Node node) throws Exception {
        Transaction tx = db.beginTx();
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        TransactionManager transactionManager = (TransactionManager)dependencyResolver.resolveDependency(TransactionManager.class);
        additionalDs.getXaConnection().enlistResource(transactionManager.getTransaction());
        node.delete();
        tx.success();
        try {
            tx.finish();
            Assert.fail((String)"This transaction shouldn't be successful");
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNodeWithOneRelationshipToIt(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            node.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    private static class VerificationLogHook
    extends LogTestUtils.LogHookAdapter<LogEntry> {
        private final Set<Xid> startXids = new HashSet<Xid>();

        private VerificationLogHook() {
        }

        public boolean accept(LogEntry item) {
            if (item instanceof LogEntry.Start) {
                Assert.assertTrue((boolean)this.startXids.add(((LogEntry.Start)item).getXid()));
            }
            return true;
        }
    }
}

