/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.test.OtherThreadExecutor;

public class TestManualAcquireLock
extends AbstractNeo4jTestCase {
    private Worker worker;

    @Before
    public void doBefore() throws Exception {
        this.worker = new Worker();
    }

    @After
    public void doAfter() throws Exception {
        this.worker.close();
    }

    @Test
    public void releaseReleaseManually() throws Exception {
        String key = "name";
        Node node = this.getGraphDb().createNode();
        Transaction tx = this.newTransaction();
        Worker worker = new Worker();
        Lock nodeLock = tx.acquireWriteLock((PropertyContainer)node);
        worker.beginTx();
        try {
            worker.setProperty(node, key, "ksjd");
            Assert.fail((String)"Shouldn't be able to grab it");
        }
        catch (Exception e) {
            // empty catch block
        }
        nodeLock.release();
        worker.setProperty(node, key, "yo");
        try {
            worker.finishTx();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    @Test
    public void canOnlyReleaseOnce() throws Exception {
        Node node = this.getGraphDb().createNode();
        Transaction tx = this.newTransaction();
        Lock nodeLock = tx.acquireWriteLock((PropertyContainer)node);
        nodeLock.release();
        try {
            nodeLock.release();
            Assert.fail((String)"Shouldn't be able to release more than once");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    @Test
    public void makeSureNodeStaysLockedEvenAfterManualRelease() throws Exception {
        String key = "name";
        Node node = this.getGraphDb().createNode();
        Transaction tx = this.newTransaction();
        Lock nodeLock = tx.acquireWriteLock((PropertyContainer)node);
        node.setProperty(key, (Object)"value");
        nodeLock.release();
        Worker worker = new Worker();
        worker.beginTx();
        try {
            worker.setProperty(node, key, "ksjd");
            Assert.fail((String)"Shouldn't be able to grab it");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.commit();
        tx.success();
        tx.finish();
        try {
            worker.finishTx();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    private class Worker
    extends OtherThreadExecutor<State> {
        public Worker() {
            super("other thread", new State(TestManualAcquireLock.this.getGraphDb()));
        }

        void beginTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx = state.graphDb.beginTx();
                    return null;
                }
            });
        }

        void finishTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx.success();
                    state.tx.finish();
                    return null;
                }
            });
        }

        void setProperty(final Node node, final String key, final Object value) throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Object>(){

                @Override
                public Object doWork(State state) {
                    node.setProperty(key, value);
                    return null;
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
    }

    private class State {
        private final GraphDatabaseService graphDb;
        private Transaction tx;

        public State(GraphDatabaseService graphDb) {
            this.graphDb = graphDb;
        }
    }
}

