/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.impl.transaction.TxLog;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.monitoring.Monitors;

public class TestTxLog {
    private final ByteBuffer globalIdBuffer = ByteBuffer.allocate(64);
    private final DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();

    private void assertEqualByteArray(byte[] a, byte[] b) {
        Assert.assertTrue((a.length == b.length ? 1 : 0) != 0);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((long)a[i], (long)b[i]);
        }
    }

    private File path() {
        String path = AbstractNeo4jTestCase.getStorePath("txlog");
        File file = new File(path);
        file.mkdirs();
        return file;
    }

    private File file(String name) {
        return new File(this.path(), name);
    }

    private File txFile() {
        return this.file("tx_test_log.tx");
    }

    private File tmpFile() throws IOException {
        File file = File.createTempFile("tx_test_log.tx.", ".tmp", this.path());
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxLog() throws IOException {
        File file = this.txFile();
        if (file.exists()) {
            file.delete();
        }
        try {
            TxLog txLog = new TxLog(this.txFile(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors());
            Assert.assertTrue((!txLog.getDanglingRecords().iterator().hasNext() ? 1 : 0) != 0);
            byte[] globalId = new byte[64];
            byte[] branchId = new byte[45];
            txLog.txStart(globalId);
            txLog.addBranch(globalId, branchId);
            Assert.assertEquals((long)2L, (long)txLog.getRecordCount());
            txLog.force();
            List<?>[] lists = this.getRecordLists(txLog.getDanglingRecords());
            Assert.assertEquals((long)1L, (long)lists.length);
            List<?> records = lists[0];
            Assert.assertEquals((long)2L, (long)records.size());
            TxLog.Record record = (TxLog.Record)records.get(0);
            Assert.assertEquals((long)1L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            Assert.assertTrue((null == record.getBranchId() ? 1 : 0) != 0);
            record = (TxLog.Record)records.get(1);
            Assert.assertEquals((long)2L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            this.assertEqualByteArray(branchId, record.getBranchId());
            txLog.markAsCommitting(globalId, ForceMode.unforced);
            Assert.assertEquals((long)3L, (long)txLog.getRecordCount());
            txLog.close();
            txLog = new TxLog(this.txFile(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors());
            Assert.assertEquals((long)0L, (long)txLog.getRecordCount());
            lists = this.getRecordLists(txLog.getDanglingRecords());
            Assert.assertEquals((long)1L, (long)lists.length);
            records = lists[0];
            Assert.assertEquals((long)3L, (long)records.size());
            record = (TxLog.Record)records.get(0);
            Assert.assertEquals((long)1L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            Assert.assertTrue((null == record.getBranchId() ? 1 : 0) != 0);
            record = (TxLog.Record)records.get(1);
            Assert.assertEquals((long)2L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            this.assertEqualByteArray(branchId, record.getBranchId());
            record = (TxLog.Record)records.get(2);
            Assert.assertEquals((long)3L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            Assert.assertTrue((null == record.getBranchId() ? 1 : 0) != 0);
            txLog.txDone(globalId);
            txLog.force();
            Assert.assertEquals((long)1L, (long)txLog.getRecordCount());
            Assert.assertEquals((long)0L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
            txLog.close();
            txLog = new TxLog(this.txFile(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors());
            Assert.assertEquals((long)0L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
            txLog.close();
        }
        finally {
            file = this.txFile();
            if (file.exists()) {
                file.delete();
            }
        }
    }

    private List<?>[] getRecordLists(Iterable<List<TxLog.Record>> danglingRecords) {
        ArrayList<List<TxLog.Record>> list = new ArrayList<List<TxLog.Record>>();
        for (List<TxLog.Record> txs : danglingRecords) {
            list.add(txs);
        }
        return list.toArray(new List[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncateTxLog() throws IOException {
        File file = this.txFile();
        if (file.exists()) {
            file.delete();
        }
        try {
            TxLog txLog = new TxLog(this.txFile(), (FileSystemAbstraction)this.fs, new Monitors());
            byte[] globalId = new byte[64];
            byte[] branchId = new byte[45];
            txLog.txStart(globalId);
            txLog.addBranch(globalId, branchId);
            txLog.markAsCommitting(globalId, ForceMode.unforced);
            txLog.truncate();
            Assert.assertEquals((long)0L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
            txLog.close();
            txLog = new TxLog(this.txFile(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors());
            txLog.txStart(globalId);
            txLog.addBranch(globalId, branchId);
            txLog.markAsCommitting(globalId, ForceMode.unforced);
            txLog.close();
            txLog = new TxLog(this.txFile(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors());
            Assert.assertEquals((long)1L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
            txLog.truncate();
            Assert.assertEquals((long)0L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
        }
        finally {
            file = this.txFile();
            if (file.exists()) {
                file.delete();
            }
        }
    }

    @Test
    public void logFilesInflatedWithZerosShouldStillBeAbleToRotate() throws IOException {
        File logFile = this.tmpFile();
        File rotationTarget = this.tmpFile();
        this.zeroPad(logFile, this.fs, 65500);
        TxLog log = new TxLog(logFile, (FileSystemAbstraction)this.fs, new Monitors());
        this.writeStartRecords(log, 2000, 0);
        log.force();
        log.switchToLogFile(rotationTarget);
        Assert.assertThat((Object)log.getRecordCount(), (Matcher)Matchers.is((Object)2000));
    }

    @Test
    public void logFilesInflatedWithZerosShouldNotSkipLastEntries() throws IOException {
        File logFile = this.tmpFile();
        TxLog log = new TxLog(logFile, (FileSystemAbstraction)this.fs, new Monitors());
        this.writeStartRecords(log, 1, 0);
        log.force();
        log.close();
        this.zeroPad(logFile, this.fs, 130998);
        log = new TxLog(logFile, (FileSystemAbstraction)this.fs, new Monitors());
        this.writeStartRecords(log, 1, 1);
        log.force();
        File rotationTarget = this.tmpFile();
        log.switchToLogFile(rotationTarget);
        Assert.assertThat((Object)log.getRecordCount(), (Matcher)Matchers.is((Object)2));
    }

    private void writeStartRecords(TxLog log, int numberOfStartRecords, int startId) throws IOException {
        for (int i = startId; i < numberOfStartRecords + startId; ++i) {
            log.txStart(this.globalId(i));
        }
    }

    private byte[] globalId(int i) {
        this.globalIdBuffer.putInt(0, i);
        byte[] bytes = new byte[64];
        this.globalIdBuffer.position(0);
        this.globalIdBuffer.get(bytes);
        return bytes;
    }

    private void zeroPad(File logFile, DefaultFileSystemAbstraction fileSystem, int numberOfNulls) throws IOException {
        StoreFileChannel ch = fileSystem.open(logFile, "rw");
        ch.position(ch.size());
        ch.write(ByteBuffer.allocate(numberOfNulls));
        ch.force(false);
        ch.close();
    }
}

