/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.TxLog;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TargetDirectory;

public class TestTxLogMonitoring {
    private static final TargetDirectory target = TargetDirectory.forTest(TestTxLogMonitoring.class);

    @Test
    public void shouldCountBytesWritten() throws Exception {
        File directory = target.cleanDirectory("shouldCountBytesWritten");
        File theLogFile = new File(directory, "theLog");
        Monitors monitors = new Monitors();
        TxLog txLog = new TxLog(theLogFile, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), monitors);
        final AtomicLong bytesWritten = new AtomicLong();
        monitors.addMonitorListener((Object)new ByteCounterMonitor(){

            public void bytesWritten(long numberOfBytes) {
                bytesWritten.addAndGet(numberOfBytes);
            }

            public void bytesRead(long numberOfBytes) {
            }
        }, new String[]{TxLog.class.getName()});
        byte[] globalId = new byte[]{1, 2, 3};
        txLog.txStart(globalId);
        txLog.addBranch(globalId, new byte[]{4, 5, 6});
        txLog.close();
        Assert.assertTrue((bytesWritten.get() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)theLogFile.length(), (long)bytesWritten.get());
    }
}

