/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.NoTransactionState;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.PlaceboTm;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnectionHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class TestXaFramework
extends AbstractNeo4jTestCase {
    private TransactionManager tm;
    private XaDataSourceManager xaDsMgr;
    private final TransactionStateFactory stateFactory = new TransactionStateFactory((Logging)new DevNullLoggingService()){

        public TransactionState create(Transaction tx) {
            return new NoTransactionState(){

                public TxIdGenerator getTxIdGenerator() {
                    return TxIdGenerator.DEFAULT;
                }
            };
        }
    };

    private File path() {
        String path = TestXaFramework.getStorePath("xafrmwrk");
        File file = new File(path);
        try {
            FileUtils.deleteRecursively((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((String)("create directory: " + file), (boolean)file.mkdirs());
        return file;
    }

    private File file(String name) {
        return new File(this.path(), name);
    }

    private File resourceFile() {
        return this.file("dummy_resource");
    }

    @Before
    public void setUpFramework() {
        this.getTransaction().finish();
        this.tm = (TransactionManager)this.getGraphDbAPI().getDependencyResolver().resolveDependency(TransactionManager.class);
        this.xaDsMgr = (XaDataSourceManager)this.getGraphDbAPI().getDependencyResolver().resolveDependency(XaDataSourceManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateXaResource() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("store_dir", "target/var");
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        KernelHealth kernelHealth = (KernelHealth)Mockito.mock(KernelHealth.class);
        this.xaDsMgr.registerDataSource((XaDataSource)new DummyXaDataSource(new HashMap<String, String>(), UTF8.encode((String)"DDDDDD"), "dummy_datasource", new XaFactory(new Config(config, new Class[]{GraphDatabaseSettings.class}), TxIdGenerator.DEFAULT, (AbstractTransactionManager)new PlaceboTm(null, (TxIdGenerator)this.getGraphDbAPI().getDependencyResolver().resolveDependency(TxIdGenerator.class)), (FileSystemAbstraction)fileSystem, new Monitors(), (Logging)new DevNullLoggingService(), RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING, kernelHealth)));
        XaDataSource xaDs = this.xaDsMgr.getXaDataSource("dummy_datasource");
        DummyXaConnection xaC = null;
        try {
            xaC = (DummyXaConnection)xaDs.getXaConnection();
            try {
                xaC.doStuff1();
                Assert.fail((String)"Non enlisted resource should throw exception");
            }
            catch (XAException e) {
                // empty catch block
            }
            XidImpl xid = new XidImpl(new byte[0], new byte[0]);
            xaC.getXaResource().start((Xid)xid, 0);
            try {
                xaC.doStuff1();
                xaC.doStuff2();
            }
            catch (XAException e) {
                Assert.fail((String)"Enlisted resource should not throw exception");
            }
            xaC.getXaResource().end((Xid)xid, 0x4000000);
            xaC.getXaResource().prepare((Xid)xid);
            xaC.getXaResource().commit((Xid)xid, false);
        }
        finally {
            this.xaDsMgr.unregisterDataSource("dummy_datasource");
            if (xaC != null) {
                xaC.destroy();
            }
        }
        this.deleteAllResourceFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxIdGeneration() throws Exception {
        DummyXaConnection xaC1 = null;
        try {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("store_dir", "target/var");
            DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
            KernelHealth kernelHealth = (KernelHealth)Mockito.mock(KernelHealth.class);
            this.xaDsMgr.registerDataSource((XaDataSource)new DummyXaDataSource(new HashMap<String, String>(), UTF8.encode((String)"DDDDDD"), "dummy_datasource1", new XaFactory(new Config(config, new Class[]{GraphDatabaseSettings.class}), TxIdGenerator.DEFAULT, (AbstractTransactionManager)this.tm, (FileSystemAbstraction)fileSystem, new Monitors(), (Logging)new DevNullLoggingService(), RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING, kernelHealth)));
            DummyXaDataSource xaDs1 = (DummyXaDataSource)this.xaDsMgr.getXaDataSource("dummy_datasource1");
            xaC1 = (DummyXaConnection)xaDs1.getXaConnection();
            this.tm.begin();
            xaC1.enlistWithTx();
            int currentTxId = xaC1.getTransactionId();
            xaC1.doStuff1();
            xaC1.delistFromTx();
            this.tm.commit();
            this.tm.begin();
            Node node = this.getGraphDb().createNode();
            xaC1.enlistWithTx();
            Assert.assertEquals((long)(++currentTxId), (long)xaC1.getTransactionId());
            xaC1.doStuff1();
            xaC1.delistFromTx();
            this.tm.commit();
            this.tm.begin();
            node = this.getGraphDb().getNodeById(node.getId());
            xaC1.enlistWithTx();
            Assert.assertEquals((long)(++currentTxId), (long)xaC1.getTransactionId());
            xaC1.doStuff2();
            xaC1.delistFromTx();
            node.delete();
            this.tm.commit();
        }
        finally {
            this.xaDsMgr.unregisterDataSource("dummy_datasource1");
            if (xaC1 != null) {
                xaC1.destroy();
            }
        }
        this.deleteAllResourceFiles();
    }

    private void deleteAllResourceFiles() {
        File dir = new File(".");
        final String prefix = this.resourceFile().getPath();
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.startsWith(prefix);
            }
        });
        boolean allDeleted = true;
        for (File file : files) {
            if (file.delete()) continue;
            allDeleted = false;
        }
        Assert.assertTrue((String)("delete all files starting with " + prefix), (boolean)allDeleted);
    }

    private class DummyXaConnection
    extends XaConnectionHelpImpl {
        private XAResource xaResource;

        public DummyXaConnection(XaResourceManager xaRm) {
            super(xaRm);
            this.xaResource = null;
            this.xaResource = new DummyXaResource(xaRm);
        }

        public XAResource getXaResource() {
            return this.xaResource;
        }

        public void doStuff1() throws XAException {
            this.validate();
            this.getTransaction().addCommand((XaCommand)new DummyCommand(1));
        }

        public void doStuff2() throws XAException {
            this.validate();
            this.getTransaction().addCommand((XaCommand)new DummyCommand(2));
        }

        public void enlistWithTx() throws Exception {
            TestXaFramework.this.tm.getTransaction().enlistResource(this.xaResource);
        }

        public void delistFromTx() throws Exception {
            TestXaFramework.this.tm.getTransaction().delistResource(this.xaResource, 0x4000000);
        }

        public int getTransactionId() throws Exception {
            return this.getTransaction().getIdentifier();
        }
    }

    private static class DummyXaResource
    extends XaResourceHelpImpl {
        DummyXaResource(XaResourceManager xaRm) {
            super(xaRm, null);
        }

        public boolean isSameRM(XAResource resource) {
            return resource instanceof DummyXaResource;
        }
    }

    public class DummyXaDataSource
    extends XaDataSource {
        private XaContainer xaContainer;

        public DummyXaDataSource(Map<String, String> map, byte[] branchId, String name, XaFactory xaFactory) throws InstantiationException {
            super(branchId, name);
            this.xaContainer = null;
            try {
                TransactionStateFactory stateFactory = new TransactionStateFactory((Logging)new DevNullLoggingService()){

                    public TransactionState create(Transaction tx) {
                        return new NoTransactionState(){

                            public TxIdGenerator getTxIdGenerator() {
                                return (TxIdGenerator)TestXaFramework.this.getGraphDbAPI().getDependencyResolver().resolveDependency(TxIdGenerator.class);
                            }
                        };
                    }
                };
                map.put("store_dir", TestXaFramework.this.path().getPath());
                this.xaContainer = xaFactory.newXaContainer((XaDataSource)this, TestXaFramework.this.resourceFile(), (XaCommandReaderFactory)new DummyCommandReaderFactory(), (XaCommandWriterFactory)new DummyCommandWriterFactory(), InjectedTransactionValidator.ALLOW_ALL, (XaTransactionFactory)new DummyTransactionFactory(), stateFactory, new TransactionInterceptorProviders(Iterables.empty(), (DependencyResolver)new DependencyResolver.Adapter(){

                    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
                        return type.cast(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.intercept_committing_transactions.name(), "false", GraphDatabaseSettings.intercept_deserialized_transactions.name(), "false"})));
                    }
                }), false, Functions.identity());
                this.xaContainer.openLogicalLog();
            }
            catch (IOException e) {
                throw new InstantiationException("" + e);
            }
        }

        public void init() {
        }

        public void start() {
        }

        public void stop() {
            this.xaContainer.close();
            TestXaFramework.this.deleteAllResourceFiles();
        }

        public void shutdown() {
        }

        public XaConnection getXaConnection() {
            return new DummyXaConnection(this.xaContainer.getResourceManager());
        }

        public long getLastCommittedTxId() {
            return 0L;
        }
    }

    private static class DummyTransactionFactory
    extends XaTransactionFactory {
        private DummyTransactionFactory() {
        }

        public XaTransaction create(long lastCommittedTxWhenTransactionStarted, TransactionState state) {
            return new DummyTransaction(this.getLogicalLog(), state);
        }

        public void flushAll() {
        }

        public long getAndSetNewVersion() {
            return 0L;
        }

        public long getCurrentVersion() {
            return 0L;
        }

        public void setVersion(long version) {
        }

        public long getLastCommittedTx() {
            return 0L;
        }
    }

    private static class DummyTransaction
    extends XaTransaction {
        private final List<XaCommand> commandList = new ArrayList<XaCommand>();

        public DummyTransaction(XaLogicalLog log, TransactionState state) {
            super(log, state);
            this.setCommitTxId(0L);
        }

        public void doAddCommand(XaCommand command) {
            this.commandList.add(command);
        }

        public void doPrepare() {
        }

        public void doRollback() {
        }

        public void doCommit() {
        }

        public boolean isReadOnly() {
            return false;
        }
    }

    private static class DummyCommandWriterFactory
    implements XaCommandWriterFactory {
        private DummyCommandWriterFactory() {
        }

        public XaCommandWriter newInstance() {
            return new XaCommandWriter(){

                public void write(XaCommand command, LogBuffer buffer) throws IOException {
                    buffer.putInt(((DummyCommand)command).getType());
                }
            };
        }
    }

    private static class DummyCommandReaderFactory
    implements XaCommandReaderFactory {
        private DummyCommandReaderFactory() {
        }

        public XaCommandReader newInstance(byte logEntryVersion, final ByteBuffer buffer) {
            return new XaCommandReader(){

                public XaCommand read(ReadableByteChannel channel) throws IOException {
                    buffer.clear();
                    buffer.limit(4);
                    if (channel.read(buffer) == 4) {
                        buffer.flip();
                        return new DummyCommand(buffer.getInt());
                    }
                    return null;
                }
            };
        }
    }

    private static class DummyCommand
    extends XaCommand {
        private final int type;

        DummyCommand(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

