/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.SystemException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.Factory;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.DummyXaDataSource;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.BufferingLogging;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TargetDirectory;

public class TxManagerTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final KernelPanicEventGenerator panicGenerator = new KernelPanicEventGenerator(new KernelEventHandlers(StringLogger.DEV_NULL));
    private final Monitors monitors = new Monitors();
    private final Logging logging = new BufferingLogging();
    private final Factory<byte[]> xidFactory = new Factory<byte[]>(){
        private final AtomicInteger id = new AtomicInteger();

        public byte[] newInstance() {
            return ("test" + this.id.incrementAndGet()).getBytes();
        }
    };
    private final LifeSupport life = new LifeSupport();

    @Test
    public void settingTmNotOkShouldAttachCauseToSubsequentErrors() throws Exception {
        XaDataSourceManager mockXaManager = (XaDataSourceManager)Mockito.mock(XaDataSourceManager.class);
        File txLogDir = TargetDirectory.forTest(this.fs.get(), this.getClass()).cleanDirectory("log");
        KernelHealth kernelHealth = new KernelHealth(this.panicGenerator, this.logging);
        TxManager txm = new TxManager(txLogDir, mockXaManager, StringLogger.DEV_NULL, (FileSystemAbstraction)this.fs.get(), null, null, kernelHealth, this.monitors);
        txm.doRecovery();
        String msg = "These kinds of throwables, breaking our transaction managers, are why we can't have nice things.";
        txm.setTmNotOk(new Throwable(msg));
        try {
            txm.begin();
            Assert.fail((String)"Should have thrown SystemException.");
        }
        catch (SystemException topLevelException) {
            Assert.assertThat((String)"TM should forward a cause.", (Object)topLevelException.getCause(), (Matcher)CoreMatchers.is(Throwable.class));
            Assert.assertThat((String)"Cause should be the original cause", (Object)topLevelException.getCause().getMessage(), (Matcher)CoreMatchers.is((Object)msg));
        }
    }

    @Test
    public void shouldNotSetTmNotOKForFailureInCommitted() throws Throwable {
        File directory = TargetDirectory.forTest(this.fs.get(), this.getClass()).cleanDirectory("dir");
        TransactionStateFactory stateFactory = new TransactionStateFactory(this.logging);
        TxIdGenerator txIdGenerator = (TxIdGenerator)Mockito.mock(TxIdGenerator.class);
        ((TxIdGenerator)Mockito.doThrow(RuntimeException.class).when((Object)txIdGenerator)).committed((XaDataSource)Matchers.any(XaDataSource.class), Matchers.anyInt(), Matchers.anyLong(), (Integer)Matchers.any(Integer.class));
        stateFactory.setDependencies((Locks)Mockito.mock(Locks.class), (NodeManager)Mockito.mock(NodeManager.class), (RemoteTxHook)Mockito.mock(RemoteTxHook.class), txIdGenerator);
        XaDataSourceManager xaDataSourceManager = (XaDataSourceManager)this.life.add((Object)new XaDataSourceManager(StringLogger.DEV_NULL));
        KernelHealth kernelHealth = new KernelHealth(this.panicGenerator, this.logging);
        AbstractTransactionManager txManager = (AbstractTransactionManager)this.life.add((Object)new TxManager(directory, xaDataSourceManager, this.logging.getMessagesLog(TxManager.class), (FileSystemAbstraction)this.fs.get(), stateFactory, this.xidFactory, kernelHealth, this.monitors));
        XaFactory xaFactory = new XaFactory(new Config(), txIdGenerator, txManager, (FileSystemAbstraction)this.fs.get(), this.monitors, this.logging, RecoveryVerifier.ALWAYS_VALID, LogPruneStrategies.NO_PRUNING, kernelHealth);
        DummyXaDataSource dataSource = new DummyXaDataSource(UTF8.encode((String)"0xDDDDDE"), "dummy", xaFactory, stateFactory, new File(directory, "log"));
        xaDataSourceManager.registerDataSource((XaDataSource)dataSource);
        this.life.start();
        txManager.doRecovery();
        txManager.begin();
        dataSource.getXaConnection().enlistResource(txManager.getTransaction());
        txManager.commit();
        Assert.assertThat((Object)this.logging.toString(), (Matcher)CoreMatchers.containsString((String)"Commit notification failed"));
        ((TxIdGenerator)Mockito.doNothing().when((Object)txIdGenerator)).committed((XaDataSource)Matchers.any(XaDataSource.class), Matchers.anyInt(), Matchers.anyLong(), (Integer)Matchers.any(Integer.class));
        txManager.begin();
        txManager.rollback();
        kernelHealth.assertHealthy(AssertionError.class);
    }

    @After
    public void after() {
        this.life.shutdown();
    }
}

